/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.vdbe;

import afu.org.tmatesoft.sqljet.core.SqlJetValueType;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import afu.org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMem;
import afu.org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFlags;

public class SqlJetVdbeSerialType {
    private static final byte[] aSize = new byte[]{0, 1, 2, 3, 4, 6, 8, 8, 0, 0, 0, 0};

    public static int serialTypeLen(int serial_type) {
        if (serial_type >= 12) {
            return (serial_type - 12) / 2;
        }
        return aSize[serial_type];
    }

    public static int serialGet(ISqlJetMemoryPointer buf, int serial_type, SqlJetVdbeMem pMem) {
        return SqlJetVdbeSerialType.serialGet(buf, 0, serial_type, pMem);
    }

    public static int serialGet(ISqlJetMemoryPointer buf, int offset, int serial_type, SqlJetVdbeMem pMem) {
        switch (serial_type) {
            case 0: 
            case 10: 
            case 11: {
                pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
                pMem.type = SqlJetValueType.NULL;
                break;
            }
            case 1: {
                pMem.i = buf.getByte(offset);
                pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                pMem.type = SqlJetValueType.INTEGER;
                return 1;
            }
            case 2: {
                pMem.i = SqlJetUtility.fromUnsigned(SqlJetUtility.getUnsignedByte(buf, offset) << 8 | SqlJetUtility.getUnsignedByte(buf, offset + 1));
                pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                pMem.type = SqlJetValueType.INTEGER;
                return 2;
            }
            case 3: {
                pMem.i = buf.getByte(offset) << 16 | SqlJetUtility.getUnsignedByte(buf, offset + 1) << 8 | SqlJetUtility.getUnsignedByte(buf, offset + 2);
                pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                pMem.type = SqlJetValueType.INTEGER;
                return 3;
            }
            case 4: {
                pMem.i = SqlJetUtility.fromUnsigned((long)(SqlJetUtility.getUnsignedByte(buf, offset) << 24 | SqlJetUtility.getUnsignedByte(buf, offset + 1) << 16 | SqlJetUtility.getUnsignedByte(buf, offset + 2) << 8 | SqlJetUtility.getUnsignedByte(buf, offset + 3)));
                pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                pMem.type = SqlJetValueType.INTEGER;
                return 4;
            }
            case 5: {
                long x = SqlJetUtility.getUnsignedByte(buf, offset) << 8 | SqlJetUtility.getUnsignedByte(buf, offset + 1);
                int y = SqlJetUtility.getUnsignedByte(buf, offset + 2) << 24 | SqlJetUtility.getUnsignedByte(buf, offset + 3) << 16 | SqlJetUtility.getUnsignedByte(buf, offset + 4) << 8 | SqlJetUtility.getUnsignedByte(buf, offset + 5);
                pMem.i = x = (long)((short)x) << 32 | SqlJetUtility.toUnsigned(y);
                pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                pMem.type = SqlJetValueType.INTEGER;
                return 6;
            }
            case 6: 
            case 7: {
                long x = SqlJetUtility.getUnsignedByte(buf, offset) << 24 | SqlJetUtility.getUnsignedByte(buf, offset + 1) << 16 | SqlJetUtility.getUnsignedByte(buf, offset + 2) << 8 | SqlJetUtility.getUnsignedByte(buf, offset + 3);
                int y = SqlJetUtility.getUnsignedByte(buf, offset + 4) << 24 | SqlJetUtility.getUnsignedByte(buf, offset + 5) << 16 | SqlJetUtility.getUnsignedByte(buf, offset + 6) << 8 | SqlJetUtility.getUnsignedByte(buf, offset + 7);
                x = (long)((int)x) << 32 | SqlJetUtility.toUnsigned(y);
                if (serial_type == 6) {
                    pMem.i = x;
                    pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                    pMem.type = SqlJetValueType.INTEGER;
                } else {
                    pMem.r = Double.longBitsToDouble(x);
                    pMem.flags = SqlJetUtility.of(pMem.r == Double.NaN ? SqlJetVdbeMemFlags.Null : SqlJetVdbeMemFlags.Real);
                    pMem.type = pMem.r == Double.NaN ? SqlJetValueType.NULL : SqlJetValueType.FLOAT;
                }
                return 8;
            }
            case 8: 
            case 9: {
                pMem.i = serial_type - 8;
                pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                pMem.type = SqlJetValueType.INTEGER;
                return 0;
            }
            default: {
                int len = (serial_type - 12) / 2;
                pMem.z = SqlJetUtility.pointer(buf, offset);
                pMem.z.limit(len);
                pMem.n = len;
                pMem.xDel = null;
                if ((serial_type & 1) != 0) {
                    pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Str, SqlJetVdbeMemFlags.Ephem);
                    pMem.type = SqlJetValueType.TEXT;
                } else {
                    pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Blob, SqlJetVdbeMemFlags.Ephem);
                    pMem.type = SqlJetValueType.BLOB;
                }
                return len;
            }
        }
        return 0;
    }

    public static int serialType(SqlJetVdbeMem pMem, int file_format) {
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Null)) {
            return 0;
        }
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Int)) {
            long MAX_6BYTE = 0x7FFFFFFFFFFFL;
            long i = pMem.i;
            if (file_format >= 4 && (i & 1L) == i) {
                return 8 + (int)i;
            }
            long u = SqlJetUtility.absolute(i);
            if (u <= 127L) {
                return 1;
            }
            if (u <= 32767L) {
                return 2;
            }
            if (u <= 0x7FFFFFL) {
                return 3;
            }
            if (u <= Integer.MAX_VALUE) {
                return 4;
            }
            if (u <= MAX_6BYTE) {
                return 5;
            }
            return 6;
        }
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Real)) {
            return 7;
        }
        int n = pMem.n;
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
            n += pMem.nZero;
        }
        assert (n >= 0);
        return n * 2 + 12 + (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) ? 1 : 0);
    }

    public static int serialPut(ISqlJetMemoryPointer buf, int nBuf, SqlJetVdbeMem pMem, int file_format) {
        int serial_type = SqlJetVdbeSerialType.serialType(pMem, file_format);
        if (serial_type <= 7 && serial_type > 0) {
            int i;
            long v = serial_type == 7 ? Double.doubleToLongBits(pMem.r) : pMem.i;
            int len = i = SqlJetVdbeSerialType.serialTypeLen(serial_type);
            assert (len <= nBuf);
            while (i-- > 0) {
                buf.putByteUnsigned(i, (int)v);
                v >>>= 8;
            }
            return len;
        }
        if (serial_type >= 12) {
            assert (pMem.n + (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero) ? pMem.nZero : 0) == SqlJetVdbeSerialType.serialTypeLen(serial_type));
            assert (pMem.n <= nBuf);
            int len = pMem.n;
            SqlJetUtility.memcpy(buf, pMem.z, len);
            if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
                if ((len += pMem.nZero) > nBuf) {
                    len = nBuf;
                }
                SqlJetUtility.memset(buf, pMem.n, (byte)0, len - pMem.n);
            }
            return len;
        }
        return 0;
    }
}

