/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.vdbe;

import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetUnpackedRecord;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetUnpackedRecordFlags;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import afu.org.tmatesoft.sqljet.core.internal.vdbe.SqlJetKeyInfo;
import afu.org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMem;
import afu.org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFlags;
import afu.org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeSerialType;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetUnpackedRecord
implements ISqlJetUnpackedRecord {
    SqlJetKeyInfo pKeyInfo;
    int nField;
    Set<SqlJetUnpackedRecordFlags> flags;
    SqlJetVdbeMem[] aMem;

    public static void delete(SqlJetUnpackedRecord p) {
        if (p != null && p.flags.contains((Object)SqlJetUnpackedRecordFlags.NEED_DESTROY)) {
            for (int i = 0; i < p.nField; ++i) {
                SqlJetVdbeMem pMem = p.aMem[i];
                if (pMem.zMalloc == null) continue;
                pMem.reset();
            }
        }
    }

    @Override
    public int recordCompare(int nKey1, ISqlJetMemoryPointer pKey1) throws SqlJetException {
        SqlJetUnpackedRecord pPKey2 = this;
        int[] szHdr1 = new int[1];
        int i = 0;
        int rc = 0;
        SqlJetVdbeMem mem1 = SqlJetVdbeMem.obtainInstance();
        SqlJetKeyInfo pKeyInfo = pPKey2.pKeyInfo;
        mem1.enc = pKeyInfo.enc;
        mem1.db = pKeyInfo.db;
        mem1.flags = SqlJetUtility.noneOf(SqlJetVdbeMemFlags.class);
        mem1.zMalloc = null;
        int idx1 = SqlJetUtility.getVarint32(pKey1, szHdr1);
        int d1 = szHdr1[0];
        if (pPKey2.flags.contains((Object)SqlJetUnpackedRecordFlags.IGNORE_ROWID)) {
            szHdr1[0] = szHdr1[0] - 1;
        }
        int nField = pKeyInfo.nField;
        while (idx1 < szHdr1[0] && i < pPKey2.nField) {
            int[] serial_type1 = new int[1];
            idx1 += SqlJetUtility.getVarint32(pKey1, idx1, serial_type1);
            if (d1 >= nKey1 && SqlJetVdbeSerialType.serialTypeLen(serial_type1[0]) > 0) break;
            d1 += SqlJetVdbeSerialType.serialGet(pKey1, d1, serial_type1[0], mem1);
            rc = SqlJetVdbeMem.compare(mem1, pPKey2.aMem[i], i < nField ? pKeyInfo.aColl[i] : null);
            if (rc != 0) break;
            ++i;
        }
        mem1.release();
        if (rc == 0) {
            if (pPKey2.flags.contains((Object)SqlJetUnpackedRecordFlags.INCRKEY)) {
                rc = -1;
            } else if (!pPKey2.flags.contains((Object)SqlJetUnpackedRecordFlags.PREFIX_MATCH) && idx1 < szHdr1[0]) {
                rc = 1;
            }
        } else if (pKeyInfo.aSortOrder != null && i < pKeyInfo.nField && pKeyInfo.aSortOrder[i]) {
            rc = -rc;
        }
        return rc;
    }

    public Set<SqlJetUnpackedRecordFlags> getFlags() {
        return this.flags;
    }

    public void setFlags(Set<SqlJetUnpackedRecordFlags> flags) {
        this.flags = flags;
    }

    @Override
    public void release() {
        if (this.aMem != null) {
            for (int i = 0; i < this.aMem.length; ++i) {
                if (this.aMem[i] == null) continue;
                this.aMem[i].release();
            }
        }
    }
}

