/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.table;

import afu.org.tmatesoft.sqljet.core.SqlJetErrorCode;
import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.SqlJetValueType;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import afu.org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import afu.org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import afu.org.tmatesoft.sqljet.core.internal.table.SqlJetRowNumCursor;
import afu.org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import afu.org.tmatesoft.sqljet.core.table.SqlJetDb;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetTableDataCursor
extends SqlJetRowNumCursor {
    public SqlJetTableDataCursor(ISqlJetBtreeDataTable table, SqlJetDb db) throws SqlJetException {
        super(table, db);
        super.first();
    }

    protected ISqlJetBtreeDataTable getBtreeDataTable() {
        return (ISqlJetBtreeDataTable)this.btreeTable;
    }

    @Override
    public long getRowId() throws SqlJetException {
        return (Long)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetBtreeDataTable table = SqlJetTableDataCursor.this.getBtreeDataTable();
                if (table.eof()) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or the current record doesn't point to a data row");
                }
                return table.getRowId();
            }
        });
    }

    @Override
    public boolean goTo(final long rowId) throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetBtreeDataTable table = SqlJetTableDataCursor.this.getBtreeDataTable();
                return table.goToRow(rowId);
            }
        });
    }

    private int getFieldSafe(String fieldName) throws SqlJetException {
        ISqlJetBtreeDataTable table = this.getBtreeDataTable();
        if (this.eof()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or the current record doesn't point to a data row");
        }
        if (fieldName == null) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Field name is null");
        }
        int field = table.getDefinition().getColumnNumber(fieldName);
        if (field < 0) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Field not found: " + fieldName);
        }
        return field;
    }

    @Override
    public SqlJetValueType getFieldType(final String fieldName) throws SqlJetException {
        return (SqlJetValueType)((Object)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetTableDataCursor.this.getBtreeDataTable().getFieldType(SqlJetTableDataCursor.this.getFieldSafe(fieldName));
            }
        }));
    }

    @Override
    public boolean isNull(final String fieldName) throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetTableDataCursor.this.getBtreeDataTable().isNull(SqlJetTableDataCursor.this.getFieldSafe(fieldName));
            }
        });
    }

    @Override
    public String getString(final String fieldName) throws SqlJetException {
        return (String)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetTableDataCursor.this.getBtreeDataTable().getString(SqlJetTableDataCursor.this.getFieldSafe(fieldName));
            }
        });
    }

    @Override
    public long getInteger(final String fieldName) throws SqlJetException {
        return (Long)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                if (SqlJetBtreeDataTable.isFieldNameRowId(fieldName)) {
                    return SqlJetTableDataCursor.this.getBtreeDataTable().getRowId();
                }
                return SqlJetTableDataCursor.this.getBtreeDataTable().getInteger(SqlJetTableDataCursor.this.getFieldSafe(fieldName));
            }
        });
    }

    @Override
    public double getFloat(final String fieldName) throws SqlJetException {
        return (Double)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetTableDataCursor.this.getBtreeDataTable().getFloat(SqlJetTableDataCursor.this.getFieldSafe(fieldName));
            }
        });
    }

    @Override
    public byte[] getBlobAsArray(final String fieldName) throws SqlJetException {
        return (byte[])this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetMemoryPointer buffer = SqlJetTableDataCursor.this.getBtreeDataTable().getBlob(SqlJetTableDataCursor.this.getFieldSafe(fieldName));
                return buffer != null ? SqlJetUtility.readByteBuffer(buffer) : null;
            }
        });
    }

    @Override
    public InputStream getBlobAsStream(final String fieldName) throws SqlJetException {
        return (InputStream)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetMemoryPointer buffer = SqlJetTableDataCursor.this.getBtreeDataTable().getBlob(SqlJetTableDataCursor.this.getFieldSafe(fieldName));
                return buffer != null ? new ByteArrayInputStream(SqlJetUtility.readByteBuffer(buffer)) : null;
            }
        });
    }

    @Override
    public Object getValue(final String fieldName) throws SqlJetException {
        return this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                if (SqlJetBtreeDataTable.isFieldNameRowId(fieldName)) {
                    return SqlJetTableDataCursor.this.getBtreeDataTable().getRowId();
                }
                return SqlJetTableDataCursor.this.getBtreeDataTable().getValue(SqlJetTableDataCursor.this.getFieldSafe(fieldName));
            }
        });
    }

    @Override
    public boolean getBoolean(final String fieldName) throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetTableDataCursor.this.getBoolean(SqlJetTableDataCursor.this.getFieldSafe(fieldName));
            }
        });
    }

    @Override
    public void update(Object ... values) throws SqlJetException {
        this.updateOr(null, values);
    }

    @Override
    public void updateOr(final SqlJetConflictAction onConflict, final Object ... values) throws SqlJetException {
        this.db.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetBtreeDataTable table = SqlJetTableDataCursor.this.getBtreeDataTable();
                if (table.eof()) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or current record doesn't't point to data row");
                }
                table.updateCurrent(onConflict, values);
                return null;
            }
        });
    }

    @Override
    public long updateWithRowId(long rowId, Object ... values) throws SqlJetException {
        return this.updateWithRowIdOr(null, rowId, values);
    }

    @Override
    public long updateWithRowIdOr(final SqlJetConflictAction onConflict, final long rowId, final Object ... values) throws SqlJetException {
        return (Long)this.db.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetBtreeDataTable table = SqlJetTableDataCursor.this.getBtreeDataTable();
                if (table.eof()) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or current record doesn't't point to data row");
                }
                return table.updateCurrentWithRowId(onConflict, rowId, values);
            }
        });
    }

    @Override
    public void updateByFieldNames(Map<String, Object> values) throws SqlJetException {
        this.updateByFieldNamesOr(null, values);
    }

    @Override
    public void updateByFieldNamesOr(final SqlJetConflictAction onConflict, final Map<String, Object> values) throws SqlJetException {
        this.db.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetBtreeDataTable table = SqlJetTableDataCursor.this.getBtreeDataTable();
                if (table.eof()) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or current record doesn't point to data row");
                }
                table.update(onConflict, values);
                return null;
            }
        });
    }

    @Override
    public void delete() throws SqlJetException {
        this.db.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetBtreeDataTable table = SqlJetTableDataCursor.this.getBtreeDataTable();
                if (table.eof()) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or current record doesn't point to data row");
                }
                table.delete();
                return null;
            }
        });
        super.delete();
    }

    @Override
    public Object[] getRowValues() throws SqlJetException {
        return (Object[])this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                Object[] values = SqlJetTableDataCursor.this.getBtreeDataTable().getValues();
                return values.clone();
            }
        });
    }
}

