/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.table;

import afu.org.tmatesoft.sqljet.core.SqlJetErrorCode;
import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.SqlJetValueType;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import afu.org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeTable;
import afu.org.tmatesoft.sqljet.core.internal.table.SqlJetReverseOrderCursor;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import afu.org.tmatesoft.sqljet.core.table.SqlJetDb;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public abstract class SqlJetCursor
implements ISqlJetCursor {
    protected final ISqlJetBtreeTable btreeTable;
    protected final SqlJetDb db;

    SqlJetCursor(ISqlJetBtreeTable table, SqlJetDb db) throws SqlJetException {
        if (!db.isInTransaction()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        }
        this.btreeTable = table;
        this.db = db;
    }

    public void close() throws SqlJetException {
        this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetCursor.this.btreeTable.close();
                return null;
            }
        });
    }

    public boolean eof() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.eof();
            }
        });
    }

    public boolean first() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.first();
            }
        });
    }

    public boolean last() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.last();
            }
        });
    }

    public boolean next() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.next();
            }
        });
    }

    public boolean previous() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.previous();
            }
        });
    }

    public int getFieldsCount() throws SqlJetException {
        return (Integer)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getFieldsCount();
            }
        });
    }

    public SqlJetValueType getFieldType(final int field) throws SqlJetException {
        return (SqlJetValueType)((Object)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getFieldType(field);
            }
        }));
    }

    public boolean isNull(final int field) throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.isNull(field);
            }
        });
    }

    public String getString(final int field) throws SqlJetException {
        return (String)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getString(field);
            }
        });
    }

    public long getInteger(final int field) throws SqlJetException {
        return (Long)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getInteger(field);
            }
        });
    }

    public double getFloat(final int field) throws SqlJetException {
        return (Double)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getFloat(field);
            }
        });
    }

    public byte[] getBlobAsArray(final int field) throws SqlJetException {
        return (byte[])this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetMemoryPointer buffer = SqlJetCursor.this.btreeTable.getBlob(field);
                return buffer != null ? SqlJetUtility.readByteBuffer(buffer) : null;
            }
        });
    }

    public InputStream getBlobAsStream(final int field) throws SqlJetException {
        return (InputStream)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetMemoryPointer buffer = SqlJetCursor.this.btreeTable.getBlob(field);
                return buffer != null ? new ByteArrayInputStream(SqlJetUtility.readByteBuffer(buffer)) : null;
            }
        });
    }

    public Object getValue(final int field) throws SqlJetException {
        return this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                Object value = SqlJetCursor.this.btreeTable.getValue(field);
                if (value instanceof ISqlJetMemoryPointer) {
                    return new ByteArrayInputStream(SqlJetUtility.readByteBuffer((ISqlJetMemoryPointer)value));
                }
                return value;
            }
        });
    }

    public boolean getBoolean(final int field) throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getInteger(field) != 0L;
            }
        });
    }

    public ISqlJetCursor reverse() throws SqlJetException {
        return new SqlJetReverseOrderCursor(this);
    }
}

