/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.map;

import afu.org.tmatesoft.sqljet.core.SqlJetEncoding;
import afu.org.tmatesoft.sqljet.core.SqlJetErrorCode;
import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import afu.org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import afu.org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import afu.org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import afu.org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import afu.org.tmatesoft.sqljet.core.map.ISqlJetMapTableCursor;
import afu.org.tmatesoft.sqljet.core.map.SqlJetMapDb;

public class SqlJetMapTableCursor
extends SqlJetBtreeTable
implements ISqlJetMapTableCursor {
    private static final String KEY_MUST_BE_MORE_THAN_ZERO = "Key must be more than zero: ";
    private final SqlJetMapDb mapDb;

    public SqlJetMapTableCursor(SqlJetMapDb mapDb, ISqlJetBtree btree, SqlJetMapDef mapDef, boolean writable) throws SqlJetException {
        super(btree, mapDef.getVirtualTableDef().getPage(), writable, false);
        if (!mapDb.isInTransaction()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        }
        this.mapDb = mapDb;
    }

    public long getKey() throws SqlJetException {
        return this.getKeySize();
    }

    public Object[] getValue() throws SqlJetException {
        return this.getValues();
    }

    public boolean goToKey(long key) throws SqlJetException {
        if (key > 0L) {
            int moveTo = this.moveTo(null, key, false);
            if (moveTo < 0 && !this.next()) {
                return false;
            }
            return moveTo == 0 || key == this.getKeySize();
        }
        throw new SqlJetException(String.format(KEY_MUST_BE_MORE_THAN_ZERO, key));
    }

    public long put(long key, Object ... values) throws SqlJetException {
        if (values != null) {
            SqlJetEncoding encoding = this.mapDb.getOptions().getEncoding();
            ISqlJetBtreeRecord record = SqlJetBtreeRecord.getRecord(encoding, values);
            ISqlJetMemoryPointer pData = record.getRawRecord();
            key = key > 0L ? key : this.newRowId();
            this.insert(null, key, pData, pData.remaining(), 0, true);
            record.release();
            return key;
        }
        if (this.goToKey(key)) {
            this.delete();
            return key;
        }
        return 0L;
    }
}

