/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.map;

import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import afu.org.tmatesoft.sqljet.core.internal.map.SqlJetMapIndexCursor;
import afu.org.tmatesoft.sqljet.core.map.ISqlJetMapIndex;
import afu.org.tmatesoft.sqljet.core.map.ISqlJetMapIndexCursor;
import afu.org.tmatesoft.sqljet.core.map.ISqlJetMapTransaction;
import afu.org.tmatesoft.sqljet.core.map.SqlJetMapDb;
import afu.org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import afu.org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import afu.org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetMapIndex
implements ISqlJetMapIndex {
    private final SqlJetMapDb mapDb;
    private final ISqlJetBtree btree;
    private ISqlJetIndexDef indexDef;
    private boolean writable;

    public SqlJetMapIndex(SqlJetMapDb mapDb, ISqlJetBtree btree, ISqlJetIndexDef indexDef, boolean writable) {
        this.mapDb = mapDb;
        this.btree = btree;
        this.indexDef = indexDef;
        this.writable = writable;
    }

    public ISqlJetMapIndexCursor getCursor() throws SqlJetException {
        return (ISqlJetMapIndexCursor)this.mapDb.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                return new SqlJetMapIndexCursor(SqlJetMapIndex.this.mapDb, SqlJetMapIndex.this.btree, SqlJetMapIndex.this.indexDef, SqlJetMapIndex.this.writable);
            }
        });
    }

    public void put(final Object[] key, final Long value) throws SqlJetException {
        if (!this.writable) {
            throw new SqlJetException("Read-only");
        }
        this.mapDb.runWriteTransaction(new ISqlJetMapTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                Object var3_3;
                ISqlJetMapIndexCursor cursor = SqlJetMapIndex.this.getCursor();
                try {
                    cursor.put(key, value);
                    var3_3 = null;
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    cursor.close();
                    throw throwable;
                }
                cursor.close();
                return var3_3;
            }
        });
    }

    public Long get(final Object[] key) throws SqlJetException {
        return (Long)this.mapDb.runReadTransaction(new ISqlJetMapTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                ISqlJetMapIndexCursor cursor;
                block3: {
                    Long l;
                    cursor = SqlJetMapIndex.this.getCursor();
                    try {
                        if (!cursor.goToKey(key)) break block3;
                        l = cursor.getValue();
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        cursor.close();
                        throw throwable;
                    }
                    cursor.close();
                    return l;
                }
                Object var3_4 = null;
                Object var5_6 = null;
                cursor.close();
                return var3_4;
            }
        });
    }
}

