/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.fs;

import afu.org.tmatesoft.sqljet.core.SqlJetErrorCode;
import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetFileSystemsManager;
import afu.org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystem;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SqlJetFileSystemsManager
implements ISqlJetFileSystemsManager {
    private Object lock = new Object();
    private ISqlJetFileSystem defaultFileSystem = null;
    private Map<String, ISqlJetFileSystem> fileSystems = new ConcurrentHashMap<String, ISqlJetFileSystem>();
    private static SqlJetFileSystemsManager manager = new SqlJetFileSystemsManager();

    protected SqlJetFileSystemsManager() {
        try {
            this.register(new SqlJetFileSystem(), true);
        }
        catch (SqlJetException e) {
            e.printStackTrace();
        }
    }

    public static SqlJetFileSystemsManager getManager() {
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetFileSystem find(String name) {
        if (null != name) {
            return this.fileSystems.get(name);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.defaultFileSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ISqlJetFileSystem fs, boolean isDefault) throws SqlJetException {
        this.checkFS(fs);
        this.fileSystems.put(fs.getName(), fs);
        if (isDefault || null == this.defaultFileSystem) {
            Object object = this.lock;
            synchronized (object) {
                this.defaultFileSystem = fs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ISqlJetFileSystem fs) throws SqlJetException {
        this.checkFS(fs);
        this.fileSystems.remove(fs.getName());
        if (fs == this.defaultFileSystem) {
            Object object = this.lock;
            synchronized (object) {
                this.defaultFileSystem = null;
                this.defaultFileSystem = this.fileSystems.size() > 0 ? this.fileSystems.values().iterator().next() : null;
            }
        }
    }

    private void checkFS(ISqlJetFileSystem fs) throws SqlJetException {
        if (null == fs) {
            throw new SqlJetException(SqlJetErrorCode.BAD_PARAMETER, "Prameter 'fs' must be not null");
        }
        if (null == fs.getName()) {
            throw new SqlJetException(SqlJetErrorCode.BAD_PARAMETER, "fs.getName() must return not null value");
        }
    }
}

