/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.fs;

import afu.org.tmatesoft.sqljet.core.SqlJetErrorCode;
import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import afu.org.tmatesoft.sqljet.core.SqlJetIOException;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetFileAccesPermission;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import afu.org.tmatesoft.sqljet.core.internal.fs.SqlJetFile;
import afu.org.tmatesoft.sqljet.core.internal.fs.SqlJetMemJournal;
import afu.org.tmatesoft.sqljet.core.internal.fs.util.SqlJetFileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.SecureRandom;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetFileSystem
implements ISqlJetFileSystem {
    public static final String FS_NAME = SqlJetFileSystem.class.getCanonicalName();
    private static final String SQLJET_TEMP_FILE_PREFIX = "tejlqs_";
    private final SecureRandom random = new SecureRandom();

    @Override
    public String getName() {
        return FS_NAME;
    }

    @Override
    public ISqlJetFile open(File path, SqlJetFileType type, Set<SqlJetFileOpenPermission> permissions) throws SqlJetException {
        File filePath;
        if (null == type) {
            throw new SqlJetException(SqlJetErrorCode.BAD_PARAMETER, "File type must not be null to open file");
        }
        if (null == permissions || permissions.isEmpty()) {
            throw new SqlJetException(SqlJetErrorCode.BAD_PARAMETER, "Permissions must not be null or empty to open file");
        }
        boolean isExclusive = permissions.contains((Object)SqlJetFileOpenPermission.EXCLUSIVE);
        boolean isDelete = permissions.contains((Object)SqlJetFileOpenPermission.DELETEONCLOSE);
        boolean isCreate = permissions.contains((Object)SqlJetFileOpenPermission.CREATE);
        boolean isReadonly = permissions.contains((Object)SqlJetFileOpenPermission.READONLY);
        boolean isReadWrite = permissions.contains((Object)SqlJetFileOpenPermission.READWRITE);
        assert (!(isReadonly && isReadWrite || !isReadWrite && !isReadonly));
        assert (!isCreate || isReadWrite);
        assert (!isExclusive || isCreate);
        assert (!isDelete || isCreate);
        assert (SqlJetFileType.MAIN_DB != type || !isDelete);
        assert (SqlJetFileType.MAIN_JOURNAL != type || !isDelete);
        assert (SqlJetFileType.MASTER_JOURNAL != type || !isDelete);
        if (null != path) {
            try {
                filePath = path.getCanonicalFile();
            }
            catch (IOException e) {
                throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)e);
            }
        }
        assert (isDelete && (!isCreate || SqlJetFileType.MASTER_JOURNAL != type && SqlJetFileType.MAIN_JOURNAL != type));
        try {
            filePath = this.getTempFile();
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)e);
        }
        assert (null != filePath);
        if (!(isReadWrite || filePath.isFile() && filePath.canRead())) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        String mode = "rw";
        if (isReadonly && !isReadWrite && !isCreate && !isExclusive) {
            mode = "r";
        } else if (isReadWrite && !isExclusive && filePath.isFile() && !filePath.canWrite() && filePath.canRead()) {
            EnumSet<SqlJetFileOpenPermission> ro = EnumSet.copyOf(permissions);
            ro.remove((Object)SqlJetFileOpenPermission.READWRITE);
            ro.remove((Object)SqlJetFileOpenPermission.CREATE);
            ro.add(SqlJetFileOpenPermission.READONLY);
            return this.open(filePath, type, ro);
        }
        RandomAccessFile file = null;
        try {
            file = SqlJetFileUtil.openFile(filePath, mode);
        }
        catch (FileNotFoundException e) {
            if (isReadWrite && !isExclusive) {
                EnumSet<SqlJetFileOpenPermission> ro = EnumSet.copyOf(permissions);
                ro.remove((Object)SqlJetFileOpenPermission.READWRITE);
                ro.remove((Object)SqlJetFileOpenPermission.CREATE);
                ro.add(SqlJetFileOpenPermission.READONLY);
                return this.open(filePath, type, ro);
            }
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        boolean noLock = SqlJetFileType.MAIN_DB != type;
        return new SqlJetFile(this, file, filePath, type, permissions, noLock);
    }

    @Override
    public File getTempFile() throws IOException {
        return File.createTempFile(SQLJET_TEMP_FILE_PREFIX, null);
    }

    @Override
    public boolean delete(File path, boolean sync) {
        assert (null != path);
        return SqlJetFileUtil.deleteFile(path, sync);
    }

    @Override
    public boolean access(File path, SqlJetFileAccesPermission permission) throws SqlJetException {
        assert (null != path);
        assert (null != permission);
        switch (permission) {
            case EXISTS: {
                return path.exists();
            }
            case READONLY: {
                return path.canRead() && !path.canWrite();
            }
            case READWRITE: {
                return path.canRead() && path.canWrite();
            }
        }
        throw new SqlJetException(SqlJetErrorCode.INTERNAL, "Unhandled SqlJetFileAccesPermission value :" + permission.name());
    }

    @Override
    public long currentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public byte[] randomness(int numBytes) {
        assert (numBytes > 0);
        byte[] bytes = new byte[numBytes];
        this.random.nextBytes(bytes);
        return bytes;
    }

    @Override
    public long sleep(long microseconds) {
        assert (microseconds > 0L);
        long t = System.currentTimeMillis();
        try {
            Thread.sleep(microseconds);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return System.currentTimeMillis() - t;
    }

    @Override
    public ISqlJetFile memJournalOpen() {
        return new SqlJetMemJournal();
    }

    @Override
    public String getFullPath(File filename) throws SqlJetException {
        assert (filename != null);
        try {
            return filename.getCanonicalPath();
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_ACCESS, (Throwable)e);
        }
    }
}

