/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.subversion.javahl;

import afu.org.apache.subversion.javahl.types.Version;

public class NativeResources {
    private static Version version;

    public static Version getVersion() {
        return version;
    }

    public static synchronized void loadNativeLibrary() {
        String[] libraryNames;
        UnsatisfiedLinkError loadException = null;
        try {
            String specifiedLibraryName = System.getProperty("subversion.native.library");
            if (specifiedLibraryName != null) {
                System.load(specifiedLibraryName);
                NativeResources.init();
                return;
            }
        }
        catch (UnsatisfiedLinkError ex) {
            loadException = ex;
        }
        for (String libraryName : libraryNames = new String[]{"svnjavahl-1", "libsvnjavahl-1", "svnjavahl"}) {
            try {
                System.loadLibrary(libraryName);
                NativeResources.init();
                return;
            }
            catch (UnsatisfiedLinkError ex) {
                if (loadException != null) continue;
                loadException = ex;
            }
        }
        if (loadException == null) {
            loadException = new UnsatisfiedLinkError("Unable to load JavaHL native library");
        }
        throw loadException;
    }

    private static final void init() {
        NativeResources.initNativeLibrary();
        version = new Version();
        if (!version.isAtLeast(1, 8, 0)) {
            throw new LinkageError("Native library version must be at least 1.8.0, but is only " + version);
        }
    }

    private static native void initNativeLibrary();
}

