/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier.structurals;

import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.ReferenceType;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.verifier.exc.AssertionViolatedException;
import afu.org.apache.commons.bcel6.verifier.exc.StructuralCodeConstraintException;
import afu.org.apache.commons.bcel6.verifier.structurals.UninitializedObjectType;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.ArrayList;

public class OperandStack
implements Cloneable {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ArrayList<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type> stack = new ArrayList();
    private final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int maxStack;

    public OperandStack(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int maxStack) {
        this.maxStack = maxStack;
    }

    public OperandStack(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int maxStack, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType obj) {
        this.maxStack = maxStack;
        this.push(obj);
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object clone() {
        ArrayList clone;
        OperandStack newstack = new OperandStack(this.maxStack);
        newstack.stack = clone = (ArrayList)this.stack.clone();
        return newstack;
    }

    public void clear() {
        this.stack = new ArrayList();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return this.stack.hashCode();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o) {
        if (!(o instanceof OperandStack)) {
            return false;
        }
        OperandStack s2 = (OperandStack)o;
        return this.stack.equals(s2.stack);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString OperandStack getClone() {
        return (OperandStack)this.clone();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int maxStack() {
        return this.maxStack;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type peek() {
        return this.peek(0);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type peek(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int i) {
        return this.stack.get(this.size() - i - 1);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type pop() {
        Type e = this.stack.remove(this.size() - 1);
        return e;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type pop(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int i) {
        for (int j = 0; j < i; ++j) {
            this.pop();
        }
        return null;
    }

    public void push(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type type) {
        if (type == null) {
            throw new AssertionViolatedException("Cannot push NULL onto OperandStack.");
        }
        if (type == Type.BOOLEAN || type == Type.CHAR || type == Type.BYTE || type == Type.SHORT) {
            throw new AssertionViolatedException("The OperandStack does not know about '" + type + "'; use Type.INT instead.");
        }
        if (this.slotsUsed() >= this.maxStack) {
            throw new AssertionViolatedException("OperandStack too small, should have thrown proper Exception elsewhere. Stack: " + this);
        }
        this.stack.add(type);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int size() {
        return this.stack.size();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int slotsUsed() {
        int slots = 0;
        for (int i = 0; i < this.stack.size(); ++i) {
            slots += this.peek(i).getSize();
        }
        return slots;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Slots used: ");
        sb.append(this.slotsUsed());
        sb.append(" MaxStack: ");
        sb.append(this.maxStack);
        sb.append(".\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.peek(i));
            sb.append(" (Size: ");
            sb.append(String.valueOf(this.peek(i).getSize()));
            sb.append(")\n");
        }
        return sb.toString();
    }

    public void merge(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString OperandStack s2) {
        try {
            if (this.slotsUsed() != s2.slotsUsed() || this.size() != s2.size()) {
                throw new StructuralCodeConstraintException("Cannot merge stacks of different size:\nOperandStack A:\n" + this + "\nOperandStack B:\n" + s2);
            }
            for (int i = 0; i < this.size(); ++i) {
                if (!(this.stack.get(i) instanceof UninitializedObjectType) && s2.stack.get(i) instanceof UninitializedObjectType) {
                    throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
                }
                if (!this.stack.get(i).equals(s2.stack.get(i)) && this.stack.get(i) instanceof UninitializedObjectType && !(s2.stack.get(i) instanceof UninitializedObjectType)) {
                    throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
                }
                if (this.stack.get(i) instanceof UninitializedObjectType && !(s2.stack.get(i) instanceof UninitializedObjectType)) {
                    this.stack.set(i, ((UninitializedObjectType)this.stack.get(i)).getInitialized());
                }
                if (this.stack.get(i).equals(s2.stack.get(i))) continue;
                if (this.stack.get(i) instanceof ReferenceType && s2.stack.get(i) instanceof ReferenceType) {
                    this.stack.set(i, ((ReferenceType)this.stack.get(i)).getFirstCommonSuperclass((ReferenceType)s2.stack.get(i)));
                    continue;
                }
                throw new StructuralCodeConstraintException("Cannot merge stacks of different types:\nStack A:\n" + this + "\nStack B:\n" + s2);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    public void initializeObject(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString UninitializedObjectType u) {
        for (int i = 0; i < this.stack.size(); ++i) {
            if (this.stack.get(i) != u) continue;
            this.stack.set(i, u.getInitialized());
        }
    }
}

