/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier.structurals;

import afu.org.apache.commons.bcel6.generic.ReferenceType;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.verifier.exc.AssertionViolatedException;
import afu.org.apache.commons.bcel6.verifier.exc.StructuralCodeConstraintException;
import afu.org.apache.commons.bcel6.verifier.structurals.UninitializedObjectType;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;

public class LocalVariables
implements Cloneable {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] locals;

    public LocalVariables(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int maxLocals) {
        this.locals = new Type[maxLocals];
        for (int i = 0; i < maxLocals; ++i) {
            this.locals[i] = Type.UNKNOWN;
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object clone() {
        LocalVariables lvs = new LocalVariables(this.locals.length);
        for (int i = 0; i < this.locals.length; ++i) {
            lvs.locals[i] = this.locals[i];
        }
        return lvs;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type get(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int i) {
        return this.locals[i];
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int maxLocals() {
        return this.locals.length;
    }

    public void set(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int i, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[i] = type;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return this.locals.length;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o) {
        if (!(o instanceof LocalVariables)) {
            return false;
        }
        LocalVariables lv = (LocalVariables)o;
        if (this.locals.length != lv.locals.length) {
            return false;
        }
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i].equals(lv.locals[i])) continue;
            return false;
        }
        return true;
    }

    public void merge(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariables lv) {
        if (this.locals.length != lv.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        for (int i = 0; i < this.locals.length; ++i) {
            this.merge(lv, i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariables lv, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int i) {
        try {
            if (!(this.locals[i] instanceof UninitializedObjectType) && lv.locals[i] instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (!this.locals[i].equals(lv.locals[i]) && this.locals[i] instanceof UninitializedObjectType && lv.locals[i] instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (this.locals[i] instanceof UninitializedObjectType && !(lv.locals[i] instanceof UninitializedObjectType)) {
                this.locals[i] = ((UninitializedObjectType)this.locals[i]).getInitialized();
            }
            if (this.locals[i] instanceof ReferenceType && lv.locals[i] instanceof ReferenceType) {
                if (this.locals[i].equals(lv.locals[i])) return;
                ReferenceType sup = ((ReferenceType)this.locals[i]).getFirstCommonSuperclass((ReferenceType)lv.locals[i]);
                if (sup == null) throw new AssertionViolatedException("Could not load all the super classes of '" + this.locals[i] + "' and '" + lv.locals[i] + "'.");
                this.locals[i] = sup;
                return;
            } else {
                if (this.locals[i].equals(lv.locals[i])) return;
                this.locals[i] = Type.UNKNOWN;
            }
            return;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.locals.length; ++i) {
            sb.append(Integer.toString(i));
            sb.append(": ");
            sb.append(this.locals[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void initializeObject(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString UninitializedObjectType u) {
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i] != u) continue;
            this.locals[i] = u.getInitialized();
        }
    }
}

