/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier.structurals;

import afu.org.apache.commons.bcel6.Repository;
import afu.org.apache.commons.bcel6.classfile.AccessFlags;
import afu.org.apache.commons.bcel6.classfile.Constant;
import afu.org.apache.commons.bcel6.classfile.ConstantClass;
import afu.org.apache.commons.bcel6.classfile.ConstantDouble;
import afu.org.apache.commons.bcel6.classfile.ConstantFieldref;
import afu.org.apache.commons.bcel6.classfile.ConstantFloat;
import afu.org.apache.commons.bcel6.classfile.ConstantInteger;
import afu.org.apache.commons.bcel6.classfile.ConstantLong;
import afu.org.apache.commons.bcel6.classfile.ConstantString;
import afu.org.apache.commons.bcel6.classfile.Field;
import afu.org.apache.commons.bcel6.classfile.FieldOrMethod;
import afu.org.apache.commons.bcel6.classfile.JavaClass;
import afu.org.apache.commons.bcel6.generic.AALOAD;
import afu.org.apache.commons.bcel6.generic.AASTORE;
import afu.org.apache.commons.bcel6.generic.ACONST_NULL;
import afu.org.apache.commons.bcel6.generic.ALOAD;
import afu.org.apache.commons.bcel6.generic.ANEWARRAY;
import afu.org.apache.commons.bcel6.generic.ARETURN;
import afu.org.apache.commons.bcel6.generic.ARRAYLENGTH;
import afu.org.apache.commons.bcel6.generic.ASTORE;
import afu.org.apache.commons.bcel6.generic.ATHROW;
import afu.org.apache.commons.bcel6.generic.ArrayType;
import afu.org.apache.commons.bcel6.generic.BALOAD;
import afu.org.apache.commons.bcel6.generic.BASTORE;
import afu.org.apache.commons.bcel6.generic.BIPUSH;
import afu.org.apache.commons.bcel6.generic.BREAKPOINT;
import afu.org.apache.commons.bcel6.generic.CALOAD;
import afu.org.apache.commons.bcel6.generic.CASTORE;
import afu.org.apache.commons.bcel6.generic.CHECKCAST;
import afu.org.apache.commons.bcel6.generic.CPInstruction;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.D2F;
import afu.org.apache.commons.bcel6.generic.D2I;
import afu.org.apache.commons.bcel6.generic.D2L;
import afu.org.apache.commons.bcel6.generic.DADD;
import afu.org.apache.commons.bcel6.generic.DALOAD;
import afu.org.apache.commons.bcel6.generic.DASTORE;
import afu.org.apache.commons.bcel6.generic.DCMPG;
import afu.org.apache.commons.bcel6.generic.DCMPL;
import afu.org.apache.commons.bcel6.generic.DCONST;
import afu.org.apache.commons.bcel6.generic.DDIV;
import afu.org.apache.commons.bcel6.generic.DLOAD;
import afu.org.apache.commons.bcel6.generic.DMUL;
import afu.org.apache.commons.bcel6.generic.DNEG;
import afu.org.apache.commons.bcel6.generic.DREM;
import afu.org.apache.commons.bcel6.generic.DRETURN;
import afu.org.apache.commons.bcel6.generic.DSTORE;
import afu.org.apache.commons.bcel6.generic.DSUB;
import afu.org.apache.commons.bcel6.generic.DUP;
import afu.org.apache.commons.bcel6.generic.DUP2;
import afu.org.apache.commons.bcel6.generic.DUP2_X1;
import afu.org.apache.commons.bcel6.generic.DUP2_X2;
import afu.org.apache.commons.bcel6.generic.DUP_X1;
import afu.org.apache.commons.bcel6.generic.DUP_X2;
import afu.org.apache.commons.bcel6.generic.EmptyVisitor;
import afu.org.apache.commons.bcel6.generic.F2D;
import afu.org.apache.commons.bcel6.generic.F2I;
import afu.org.apache.commons.bcel6.generic.F2L;
import afu.org.apache.commons.bcel6.generic.FADD;
import afu.org.apache.commons.bcel6.generic.FALOAD;
import afu.org.apache.commons.bcel6.generic.FASTORE;
import afu.org.apache.commons.bcel6.generic.FCMPG;
import afu.org.apache.commons.bcel6.generic.FCMPL;
import afu.org.apache.commons.bcel6.generic.FCONST;
import afu.org.apache.commons.bcel6.generic.FDIV;
import afu.org.apache.commons.bcel6.generic.FLOAD;
import afu.org.apache.commons.bcel6.generic.FMUL;
import afu.org.apache.commons.bcel6.generic.FNEG;
import afu.org.apache.commons.bcel6.generic.FREM;
import afu.org.apache.commons.bcel6.generic.FRETURN;
import afu.org.apache.commons.bcel6.generic.FSTORE;
import afu.org.apache.commons.bcel6.generic.FSUB;
import afu.org.apache.commons.bcel6.generic.FieldInstruction;
import afu.org.apache.commons.bcel6.generic.GETFIELD;
import afu.org.apache.commons.bcel6.generic.GETSTATIC;
import afu.org.apache.commons.bcel6.generic.GOTO;
import afu.org.apache.commons.bcel6.generic.GOTO_W;
import afu.org.apache.commons.bcel6.generic.I2B;
import afu.org.apache.commons.bcel6.generic.I2C;
import afu.org.apache.commons.bcel6.generic.I2D;
import afu.org.apache.commons.bcel6.generic.I2F;
import afu.org.apache.commons.bcel6.generic.I2L;
import afu.org.apache.commons.bcel6.generic.I2S;
import afu.org.apache.commons.bcel6.generic.IADD;
import afu.org.apache.commons.bcel6.generic.IALOAD;
import afu.org.apache.commons.bcel6.generic.IAND;
import afu.org.apache.commons.bcel6.generic.IASTORE;
import afu.org.apache.commons.bcel6.generic.ICONST;
import afu.org.apache.commons.bcel6.generic.IDIV;
import afu.org.apache.commons.bcel6.generic.IFEQ;
import afu.org.apache.commons.bcel6.generic.IFGE;
import afu.org.apache.commons.bcel6.generic.IFGT;
import afu.org.apache.commons.bcel6.generic.IFLE;
import afu.org.apache.commons.bcel6.generic.IFLT;
import afu.org.apache.commons.bcel6.generic.IFNE;
import afu.org.apache.commons.bcel6.generic.IFNONNULL;
import afu.org.apache.commons.bcel6.generic.IFNULL;
import afu.org.apache.commons.bcel6.generic.IF_ACMPEQ;
import afu.org.apache.commons.bcel6.generic.IF_ACMPNE;
import afu.org.apache.commons.bcel6.generic.IF_ICMPEQ;
import afu.org.apache.commons.bcel6.generic.IF_ICMPGE;
import afu.org.apache.commons.bcel6.generic.IF_ICMPGT;
import afu.org.apache.commons.bcel6.generic.IF_ICMPLE;
import afu.org.apache.commons.bcel6.generic.IF_ICMPLT;
import afu.org.apache.commons.bcel6.generic.IF_ICMPNE;
import afu.org.apache.commons.bcel6.generic.IINC;
import afu.org.apache.commons.bcel6.generic.ILOAD;
import afu.org.apache.commons.bcel6.generic.IMPDEP1;
import afu.org.apache.commons.bcel6.generic.IMPDEP2;
import afu.org.apache.commons.bcel6.generic.IMUL;
import afu.org.apache.commons.bcel6.generic.INEG;
import afu.org.apache.commons.bcel6.generic.INSTANCEOF;
import afu.org.apache.commons.bcel6.generic.INVOKEDYNAMIC;
import afu.org.apache.commons.bcel6.generic.INVOKEINTERFACE;
import afu.org.apache.commons.bcel6.generic.INVOKESPECIAL;
import afu.org.apache.commons.bcel6.generic.INVOKESTATIC;
import afu.org.apache.commons.bcel6.generic.INVOKEVIRTUAL;
import afu.org.apache.commons.bcel6.generic.IOR;
import afu.org.apache.commons.bcel6.generic.IREM;
import afu.org.apache.commons.bcel6.generic.IRETURN;
import afu.org.apache.commons.bcel6.generic.ISHL;
import afu.org.apache.commons.bcel6.generic.ISHR;
import afu.org.apache.commons.bcel6.generic.ISTORE;
import afu.org.apache.commons.bcel6.generic.ISUB;
import afu.org.apache.commons.bcel6.generic.IUSHR;
import afu.org.apache.commons.bcel6.generic.IXOR;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.InvokeInstruction;
import afu.org.apache.commons.bcel6.generic.JSR;
import afu.org.apache.commons.bcel6.generic.JSR_W;
import afu.org.apache.commons.bcel6.generic.L2D;
import afu.org.apache.commons.bcel6.generic.L2F;
import afu.org.apache.commons.bcel6.generic.L2I;
import afu.org.apache.commons.bcel6.generic.LADD;
import afu.org.apache.commons.bcel6.generic.LALOAD;
import afu.org.apache.commons.bcel6.generic.LAND;
import afu.org.apache.commons.bcel6.generic.LASTORE;
import afu.org.apache.commons.bcel6.generic.LCMP;
import afu.org.apache.commons.bcel6.generic.LCONST;
import afu.org.apache.commons.bcel6.generic.LDC;
import afu.org.apache.commons.bcel6.generic.LDC2_W;
import afu.org.apache.commons.bcel6.generic.LDC_W;
import afu.org.apache.commons.bcel6.generic.LDIV;
import afu.org.apache.commons.bcel6.generic.LLOAD;
import afu.org.apache.commons.bcel6.generic.LMUL;
import afu.org.apache.commons.bcel6.generic.LNEG;
import afu.org.apache.commons.bcel6.generic.LOOKUPSWITCH;
import afu.org.apache.commons.bcel6.generic.LOR;
import afu.org.apache.commons.bcel6.generic.LREM;
import afu.org.apache.commons.bcel6.generic.LRETURN;
import afu.org.apache.commons.bcel6.generic.LSHL;
import afu.org.apache.commons.bcel6.generic.LSHR;
import afu.org.apache.commons.bcel6.generic.LSTORE;
import afu.org.apache.commons.bcel6.generic.LSUB;
import afu.org.apache.commons.bcel6.generic.LUSHR;
import afu.org.apache.commons.bcel6.generic.LXOR;
import afu.org.apache.commons.bcel6.generic.LoadClass;
import afu.org.apache.commons.bcel6.generic.LoadInstruction;
import afu.org.apache.commons.bcel6.generic.LocalVariableInstruction;
import afu.org.apache.commons.bcel6.generic.MONITORENTER;
import afu.org.apache.commons.bcel6.generic.MONITOREXIT;
import afu.org.apache.commons.bcel6.generic.MULTIANEWARRAY;
import afu.org.apache.commons.bcel6.generic.MethodGen;
import afu.org.apache.commons.bcel6.generic.NEW;
import afu.org.apache.commons.bcel6.generic.NEWARRAY;
import afu.org.apache.commons.bcel6.generic.NOP;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.POP;
import afu.org.apache.commons.bcel6.generic.POP2;
import afu.org.apache.commons.bcel6.generic.PUTFIELD;
import afu.org.apache.commons.bcel6.generic.PUTSTATIC;
import afu.org.apache.commons.bcel6.generic.RET;
import afu.org.apache.commons.bcel6.generic.RETURN;
import afu.org.apache.commons.bcel6.generic.ReferenceType;
import afu.org.apache.commons.bcel6.generic.ReturnInstruction;
import afu.org.apache.commons.bcel6.generic.ReturnaddressType;
import afu.org.apache.commons.bcel6.generic.SALOAD;
import afu.org.apache.commons.bcel6.generic.SASTORE;
import afu.org.apache.commons.bcel6.generic.SIPUSH;
import afu.org.apache.commons.bcel6.generic.SWAP;
import afu.org.apache.commons.bcel6.generic.StackConsumer;
import afu.org.apache.commons.bcel6.generic.StackInstruction;
import afu.org.apache.commons.bcel6.generic.StackProducer;
import afu.org.apache.commons.bcel6.generic.StoreInstruction;
import afu.org.apache.commons.bcel6.generic.TABLESWITCH;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.verifier.VerificationResult;
import afu.org.apache.commons.bcel6.verifier.Verifier;
import afu.org.apache.commons.bcel6.verifier.VerifierFactory;
import afu.org.apache.commons.bcel6.verifier.exc.AssertionViolatedException;
import afu.org.apache.commons.bcel6.verifier.exc.StructuralCodeConstraintException;
import afu.org.apache.commons.bcel6.verifier.structurals.Frame;
import afu.org.apache.commons.bcel6.verifier.structurals.GenericArray;
import afu.org.apache.commons.bcel6.verifier.structurals.LocalVariables;
import afu.org.apache.commons.bcel6.verifier.structurals.OperandStack;
import afu.org.apache.commons.bcel6.verifier.structurals.UninitializedObjectType;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;

public class InstConstraintVisitor
extends EmptyVisitor {
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType GENERIC_ARRAY = ObjectType.getInstance(GenericArray.class.getName());
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Frame frame = null;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg = null;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MethodGen mg = null;

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString OperandStack stack() {
        return this.frame.getStack();
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariables locals() {
        return this.frame.getLocals();
    }

    private void constraintViolated(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction violator, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String description) {
        String fq_classname = violator.getClass().getName();
        throw new StructuralCodeConstraintException("Instruction " + fq_classname.substring(fq_classname.lastIndexOf(46) + 1) + " constraint violated: " + description);
    }

    public void setFrame(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Frame f) {
        this.frame = f;
    }

    public void setConstantPoolGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        this.cpg = cpg;
    }

    public void setMethodGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MethodGen mg) {
        this.mg = mg;
    }

    private void indexOfInt(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction o, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type index) {
        if (!index.equals(Type.INT)) {
            this.constraintViolated(o, "The 'index' is not of type int but of type " + index + ".");
        }
    }

    private void referenceTypeIsInitialized(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction o, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ReferenceType r) {
        if (r instanceof UninitializedObjectType) {
            this.constraintViolated(o, "Working on an uninitialized object '" + r + "'.");
        }
    }

    private void valueOfInt(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction o, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type value) {
        if (!value.equals(Type.INT)) {
            this.constraintViolated(o, "The 'value' is not of type int but of type " + value + ".");
        }
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean arrayrefOfArrayType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction o, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type arrayref) {
        if (!(arrayref instanceof ArrayType) && !arrayref.equals(Type.NULL)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array but is of type " + arrayref + ".");
        }
        return arrayref instanceof ArrayType;
    }

    private void _visitStackAccessor(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction o) {
        int produce;
        int consume = o.consumeStack(this.cpg);
        if (consume > this.stack().slotsUsed()) {
            this.constraintViolated(o, "Cannot consume " + consume + " stack slots: only " + this.stack().slotsUsed() + " slot(s) left on stack!\nStack:\n" + this.stack());
        }
        if ((produce = o.produceStack(this.cpg) - o.consumeStack(this.cpg)) + this.stack().slotsUsed() > this.stack().maxStack()) {
            this.constraintViolated(o, "Cannot produce " + produce + " stack slots: only " + (this.stack().maxStack() - this.stack().slotsUsed()) + " free stack slot(s) left.\nStack:\n" + this.stack());
        }
    }

    @Override
    public void visitLoadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LoadClass o) {
        Verifier v;
        VerificationResult vr;
        ObjectType t = o.getLoadClassType(this.cpg);
        if (t != null && (vr = (v = VerifierFactory.getVerifier(t.getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated((Instruction)((Object)o), "Class '" + o.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
    }

    @Override
    public void visitStackConsumer(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StackConsumer o) {
        this._visitStackAccessor((Instruction)((Object)o));
    }

    @Override
    public void visitStackProducer(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StackProducer o) {
        this._visitStackAccessor((Instruction)((Object)o));
    }

    @Override
    public void visitCPInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CPInstruction o) {
        int idx = o.getIndex();
        if (idx < 0 || idx >= this.cpg.getSize()) {
            throw new AssertionViolatedException("Huh?! Constant pool index of instruction '" + o + "' illegal? Pass 3a should have checked this!");
        }
    }

    @Override
    public void visitFieldInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FieldInstruction o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t;
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantFieldref)) {
            this.constraintViolated(o, "Index '" + o.getIndex() + "' should refer to a CONSTANT_Fieldref_info structure, but refers to '" + c + "'.");
        }
        if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
    }

    @Override
    public void visitInvokeInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InvokeInstruction o) {
    }

    @Override
    public void visitStackInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StackInstruction o) {
        this._visitStackAccessor(o);
    }

    @Override
    public void visitLocalVariableInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariableInstruction o) {
        if (this.locals().maxLocals() <= (o.getType(this.cpg).getSize() == 1 ? o.getIndex() : o.getIndex() + 1)) {
            this.constraintViolated(o, "The 'index' is not a valid index into the local variable array.");
        }
    }

    @Override
    public void visitLoadInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LoadInstruction o) {
        if (this.locals().get(o.getIndex()) == Type.UNKNOWN) {
            this.constraintViolated(o, "Read-Access on local variable " + o.getIndex() + " with unknown content.");
        }
        if (o.getType(this.cpg).getSize() == 2 && this.locals().get(o.getIndex() + 1) != Type.UNKNOWN) {
            this.constraintViolated(o, "Reading a two-locals value from local variables " + o.getIndex() + " and " + (o.getIndex() + 1) + " where the latter one is destroyed.");
        }
        if (!(o instanceof ALOAD)) {
            if (this.locals().get(o.getIndex()) != o.getType(this.cpg)) {
                this.constraintViolated(o, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(o.getIndex()) + "'; Instruction type: '" + o.getType(this.cpg) + "'.");
            }
        } else if (!(this.locals().get(o.getIndex()) instanceof ReferenceType)) {
            this.constraintViolated(o, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(o.getIndex()) + "'; Instruction expects a ReferenceType.");
        }
        if (this.stack().maxStack() - this.stack().slotsUsed() < o.getType(this.cpg).getSize()) {
            this.constraintViolated(o, "Not enough free stack slots to load a '" + o.getType(this.cpg) + "' onto the OperandStack.");
        }
    }

    @Override
    public void visitStoreInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StoreInstruction o) {
        if (this.stack().isEmpty()) {
            this.constraintViolated(o, "Cannot STORE: Stack to read from is empty.");
        }
        if (!(o instanceof ASTORE)) {
            if (this.stack().peek() != o.getType(this.cpg)) {
                this.constraintViolated(o, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction type: '" + o.getType(this.cpg) + "'.");
            }
        } else {
            Type stacktop = this.stack().peek();
            if (!(stacktop instanceof ReferenceType) && !(stacktop instanceof ReturnaddressType)) {
                this.constraintViolated(o, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction expects a ReferenceType or a ReturnadressType.");
            }
        }
    }

    @Override
    public void visitReturnInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ReturnInstruction o) {
        Type method_type = this.mg.getType();
        if (method_type == Type.BOOLEAN || method_type == Type.BYTE || method_type == Type.SHORT || method_type == Type.CHAR) {
            method_type = Type.INT;
        }
        if (o instanceof RETURN) {
            if (method_type != Type.VOID) {
                this.constraintViolated(o, "RETURN instruction in non-void method.");
            } else {
                return;
            }
        }
        if (o instanceof ARETURN) {
            if (method_type == Type.VOID) {
                this.constraintViolated(o, "ARETURN instruction in void method.");
            }
            if (this.stack().peek() == Type.NULL) {
                return;
            }
            if (!(this.stack().peek() instanceof ReferenceType)) {
                this.constraintViolated(o, "Reference type expected on top of stack, but is: '" + this.stack().peek() + "'.");
            }
            this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
        } else if (!method_type.equals(this.stack().peek())) {
            this.constraintViolated(o, "Current method has return type of '" + this.mg.getType() + "' expecting a '" + method_type + "' on top of the stack. But stack top is a '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitAALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AALOAD o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (this.arrayrefOfArrayType(o, arrayref) && !(((ArrayType)arrayref).getElementType() instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)arrayref).getElementType() + ".");
        }
    }

    @Override
    public void visitAASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AASTORE o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (!(value instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'value' is not of a ReferenceType but of type " + value + ".");
        }
        if (this.arrayrefOfArrayType(o, arrayref) && !(((ArrayType)arrayref).getElementType() instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)arrayref).getElementType() + ".");
        }
    }

    @Override
    public void visitACONST_NULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ACONST_NULL o) {
    }

    @Override
    public void visitALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ALOAD o) {
    }

    @Override
    public void visitANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ANEWARRAY o) {
        if (!this.stack().peek().equals(Type.INT)) {
            this.constraintViolated(o, "The 'count' at the stack top is not of type '" + Type.INT + "' but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitARETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ARETURN o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' at the stack top is not of a ReferenceType but of type '" + this.stack().peek() + "'.");
        }
        ReferenceType objectref = (ReferenceType)this.stack().peek();
        this.referenceTypeIsInitialized(o, objectref);
    }

    @Override
    public void visitARRAYLENGTH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ARRAYLENGTH o) {
        Type arrayref = this.stack().peek(0);
        this.arrayrefOfArrayType(o, arrayref);
    }

    @Override
    public void visitASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ASTORE o) {
        if (!(this.stack().peek() instanceof ReferenceType) && !(this.stack().peek() instanceof ReturnaddressType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType or of ReturnaddressType but of " + this.stack().peek() + ".");
        }
    }

    @Override
    public void visitATHROW(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ATHROW o) {
        try {
            ObjectType throwable;
            if (!(this.stack().peek() instanceof ObjectType) && !this.stack().peek().equals(Type.NULL)) {
                this.constraintViolated(o, "The 'objectref' is not of an (initialized) ObjectType but of type " + this.stack().peek() + ".");
            }
            if (this.stack().peek().equals(Type.NULL)) {
                return;
            }
            ObjectType exc = (ObjectType)this.stack().peek();
            if (!exc.subclassOf(throwable = (ObjectType)Type.getType("Ljava/lang/Throwable;")) && !exc.equals(throwable)) {
                this.constraintViolated(o, "The 'objectref' is not of class Throwable or of a subclass of Throwable, but of '" + this.stack().peek() + "'.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitBALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BALOAD o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.BOOLEAN) && !((ArrayType)arrayref).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)arrayref).getElementType() + "'.");
        }
    }

    @Override
    public void visitBASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BASTORE o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.valueOfInt(o, value);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.BOOLEAN) && !((ArrayType)arrayref).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)arrayref).getElementType() + "'.");
        }
    }

    @Override
    public void visitBIPUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BIPUSH o) {
    }

    @Override
    public void visitBREAKPOINT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BREAKPOINT o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as BREAKPOINT.");
    }

    @Override
    public void visitCALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CALOAD o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.arrayrefOfArrayType(o, arrayref);
    }

    @Override
    public void visitCASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CASTORE o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.valueOfInt(o, value);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.CHAR)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of type char but to an array of type " + ((ArrayType)arrayref).getElementType() + ".");
        }
    }

    @Override
    public void visitCHECKCAST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CHECKCAST o) {
        Constant c;
        Type objectref = this.stack().peek(0);
        if (!(objectref instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType but of type " + objectref + ".");
        }
        if (!((c = this.cpg.getConstant(o.getIndex())) instanceof ConstantClass)) {
            this.constraintViolated(o, "The Constant at 'index' is not a ConstantClass, but '" + c + "'.");
        }
    }

    @Override
    public void visitD2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString D2F o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitD2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString D2I o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitD2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString D2L o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitDADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DADD o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(o, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DASTORE o) {
        Type t;
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitDCMPG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DCMPG o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDCMPL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DCMPL o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DCONST o) {
    }

    @Override
    public void visitDDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DDIV o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DLOAD o) {
    }

    @Override
    public void visitDMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DMUL o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DNEG o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitDREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DREM o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DRETURN o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitDSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DSTORE o) {
    }

    @Override
    public void visitDSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DSUB o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDUP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Won't DUP type on stack top '" + this.stack().peek() + "' because it must occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
    }

    @Override
    public void visitDUP_X1(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP_X1 o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Type on stack top '" + this.stack().peek() + "' should occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "Type on stack next-to-top '" + this.stack().peek(1) + "' should occupy exactly one slot, not '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    @Override
    public void visitDUP_X2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP_X2 o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Stack top type must be of size 1, but is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() == 2) {
            return;
        }
        if (this.stack().peek(2).getSize() != 1) {
            this.constraintViolated(o, "If stack top's size is 1 and stack next-to-top's size is 1, stack next-to-next-to-top's size must also be 1, but is: '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    @Override
    public void visitDUP2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP2 o) {
        if (this.stack().peek().getSize() == 2) {
            return;
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitDUP2_X1(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP2_X1 o) {
        if (this.stack().peek().getSize() == 2) {
            if (this.stack().peek(1).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 2, then stack next-to-top's size must be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            return;
        } else {
            if (this.stack().peek(1).getSize() != 1) {
                this.constraintViolated(o, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitDUP2_X2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP2_X2 o) {
        if (this.stack().peek(0).getSize() == 2) {
            if (this.stack().peek(1).getSize() == 2) {
                return;
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 2 and stack-next-to-top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        } else if (this.stack().peek(1).getSize() == 1) {
            if (this.stack().peek(2).getSize() == 2) {
                return;
            }
            if (this.stack().peek(3).getSize() == 1) {
                return;
            }
        }
        this.constraintViolated(o, "The operand sizes on the stack do not match any of the four forms of usage of this instruction.");
    }

    @Override
    public void visitF2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString F2D o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitF2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString F2I o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitF2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString F2L o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitFADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FADD o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(o, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FASTORE o) {
        Type t;
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitFCMPG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FCMPG o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFCMPL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FCMPL o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FCONST o) {
    }

    @Override
    public void visitFDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FDIV o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FLOAD o) {
    }

    @Override
    public void visitFMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FMUL o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FNEG o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitFREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FREM o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FRETURN o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitFSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FSTORE o) {
    }

    @Override
    public void visitFSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FSUB o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType getObjectType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FieldInstruction o) {
        ReferenceType rt = o.getReferenceType(this.cpg);
        if (rt instanceof ObjectType) {
            return (ObjectType)rt;
        }
        this.constraintViolated(o, "expecting ObjectType but got " + rt);
        return null;
    }

    @Override
    public void visitGETFIELD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString GETFIELD o) {
        try {
            ObjectType curr;
            ObjectType classtype;
            Type objectref = this.stack().peek();
            if (!(objectref instanceof ObjectType) && objectref != Type.NULL) {
                this.constraintViolated(o, "Stack top should be an object reference that's not an array reference, but is '" + objectref + "'.");
            }
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
            Field[] fields = jc.getFields();
            AccessFlags f = null;
            for (Field field : fields) {
                Type o_type;
                Type f_type;
                if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.cpg))) continue;
                f = field;
                break;
            }
            if (f == null) {
                JavaClass[] superclasses;
                block3: for (JavaClass superclass : superclasses = jc.getSuperClasses()) {
                    for (Field field : fields = superclass.getFields()) {
                        Type o_type;
                        Type f_type;
                        if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.cpg))) continue;
                        f = field;
                        if ((f.getAccessFlags() & 5) != 0) break block3;
                        f = null;
                        break block3;
                    }
                }
                if (f == null) {
                    throw new AssertionViolatedException("Field '" + field_name + "' not found in " + jc.getClassName());
                }
            }
            if (f.isProtected() && ((classtype = this.getObjectType(o)).equals(curr = ObjectType.getInstance(this.mg.getClassName())) || curr.subclassOf(classtype))) {
                ObjectType objreftype;
                Type t = this.stack().peek();
                if (t == Type.NULL) {
                    return;
                }
                if (!(t instanceof ObjectType)) {
                    this.constraintViolated(o, "The 'objectref' must refer to an object that's not an array. Found instead: '" + t + "'.");
                }
                if ((objreftype = (ObjectType)t).equals(curr) || !objreftype.subclassOf(curr)) {
                    // empty if block
                }
            }
            if (f.isStatic()) {
                this.constraintViolated(o, "Referenced field '" + f + "' is static which it shouldn't be.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitGETSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString GETSTATIC o) {
    }

    @Override
    public void visitGOTO(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString GOTO o) {
    }

    @Override
    public void visitGOTO_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString GOTO_W o) {
    }

    @Override
    public void visitI2B(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2B o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2C(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2C o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2D o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2F o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2L o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2S(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2S o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IADD o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.INT) {
            this.constraintViolated(o, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIAND(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IAND o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IASTORE o) {
        Type t;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.INT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitICONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ICONST o) {
    }

    @Override
    public void visitIDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IDIV o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ACMPEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ACMPEQ o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ACMPNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ACMPNE o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPEQ o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPGE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPGE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPGT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPGT o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPLE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPLE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPLT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPLT o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPNE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIFEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFEQ o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFGE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFGE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFGT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFGT o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFLE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFLE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFLT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFLT o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFNE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFNONNULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFNONNULL o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    @Override
    public void visitIFNULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFNULL o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    @Override
    public void visitIINC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IINC o) {
        if (this.locals().maxLocals() <= (o.getType(this.cpg).getSize() == 1 ? o.getIndex() : o.getIndex() + 1)) {
            this.constraintViolated(o, "The 'index' is not a valid index into the local variable array.");
        }
        this.indexOfInt(o, this.locals().get(o.getIndex()));
    }

    @Override
    public void visitILOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ILOAD o) {
    }

    @Override
    public void visitIMPDEP1(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IMPDEP1 o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP1.");
    }

    @Override
    public void visitIMPDEP2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IMPDEP2 o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP2.");
    }

    @Override
    public void visitIMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IMUL o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitINEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INEG o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitINSTANCEOF(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INSTANCEOF o) {
        Constant c;
        Type objectref = this.stack().peek(0);
        if (!(objectref instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType but of type " + objectref + ".");
        }
        if (!((c = this.cpg.getConstant(o.getIndex())) instanceof ConstantClass)) {
            this.constraintViolated(o, "The Constant at 'index' is not a ConstantClass, but '" + c + "'.");
        }
    }

    @Override
    public void visitINVOKEDYNAMIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKEDYNAMIC o) {
        throw new RuntimeException("INVOKEDYNAMIC instruction is not supported at this time");
    }

    @Override
    public void visitINVOKEINTERFACE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKEINTERFACE o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t;
        int count = o.getCount();
        if (count == 0) {
            this.constraintViolated(o, "The 'count' argument must not be 0.");
        }
        if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        for (int i = nargs - 1; i >= 0; --i) {
            Type fromStack = this.stack().peek(nargs - 1 - i);
            Type fromDesc = argtypes[i];
            if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                fromDesc = Type.INT;
            }
            if (fromStack.equals(fromDesc)) continue;
            if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                ReferenceType rFromStack = (ReferenceType)fromStack;
                this.referenceTypeIsInitialized(o, rFromStack);
                continue;
            }
            this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
        }
        Type objref = this.stack().peek(nargs);
        if (objref == Type.NULL) {
            return;
        }
        if (!(objref instanceof ReferenceType)) {
            this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)objref);
        if (!(objref instanceof ObjectType)) {
            if (!(objref instanceof ArrayType)) {
                this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
            } else {
                objref = GENERIC_ARRAY;
            }
        }
        int counted_count = 1;
        for (int i = 0; i < nargs; ++i) {
            counted_count += argtypes[i].getSize();
        }
        if (count != counted_count) {
            this.constraintViolated(o, "The 'count' argument should probably read '" + counted_count + "' but is '" + count + "'.");
        }
    }

    @Override
    public void visitINVOKESPECIAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKESPECIAL o) {
        try {
            String name;
            Verifier v;
            VerificationResult vr;
            Type t;
            if (o.getMethodName(this.cpg).equals("<init>") && !(this.stack().peek(o.getArgumentTypes(this.cpg).length) instanceof UninitializedObjectType)) {
                this.constraintViolated(o, "Possibly initializing object twice. A valid instruction sequence must not have an uninitialized object on the operand stack or in a local variable during a backwards branch, or in a local variable in code protected by an exception handler. Please see The Java Virtual Machine Specification, Second Edition, 4.9.4 (pages 147 and 148) for details.");
            }
            if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
            }
            Type[] argtypes = o.getArgumentTypes(this.cpg);
            int nargs = argtypes.length;
            for (int i = nargs - 1; i >= 0; --i) {
                Type fromStack = this.stack().peek(nargs - 1 - i);
                Type fromDesc = argtypes[i];
                if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                    fromDesc = Type.INT;
                }
                if (fromStack.equals(fromDesc)) continue;
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                    this.referenceTypeIsInitialized(o, rFromStack);
                    continue;
                }
                this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
            }
            Type objref = this.stack().peek(nargs);
            if (objref == Type.NULL) {
                return;
            }
            if (!(objref instanceof ReferenceType)) {
                this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
            }
            String objref_classname = null;
            if (!o.getMethodName(this.cpg).equals("<init>")) {
                this.referenceTypeIsInitialized(o, (ReferenceType)objref);
                if (!(objref instanceof ObjectType)) {
                    if (!(objref instanceof ArrayType)) {
                        this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
                    } else {
                        objref = GENERIC_ARRAY;
                    }
                }
                objref_classname = ((ObjectType)objref).getClassName();
            } else {
                if (!(objref instanceof UninitializedObjectType)) {
                    this.constraintViolated(o, "Expecting an UninitializedObjectType as 'objectref' on the stack, not a '" + objref + "'. Otherwise, you couldn't invoke a method since an array has no methods (not to speak of a return address).");
                }
                objref_classname = ((UninitializedObjectType)objref).getInitialized().getClassName();
            }
            String theClass = o.getClassName(this.cpg);
            if (!Repository.instanceOf(objref_classname, theClass)) {
                this.constraintViolated(o, "The 'objref' item '" + objref + "' does not implement '" + theClass + "' as expected.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitINVOKESTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKESTATIC o) {
        try {
            String name;
            Verifier v;
            VerificationResult vr;
            Type t = o.getType(this.cpg);
            if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
            }
            Type[] argtypes = o.getArgumentTypes(this.cpg);
            int nargs = argtypes.length;
            for (int i = nargs - 1; i >= 0; --i) {
                Type fromStack = this.stack().peek(nargs - 1 - i);
                Type fromDesc = argtypes[i];
                if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                    fromDesc = Type.INT;
                }
                if (fromStack.equals(fromDesc)) continue;
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                    this.referenceTypeIsInitialized(o, rFromStack);
                    continue;
                }
                this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitINVOKEVIRTUAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKEVIRTUAL o) {
        try {
            String theClass;
            String objref_classname;
            String name;
            Verifier v;
            VerificationResult vr;
            Type t = o.getType(this.cpg);
            if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
            }
            Type[] argtypes = o.getArgumentTypes(this.cpg);
            int nargs = argtypes.length;
            for (int i = nargs - 1; i >= 0; --i) {
                Type fromStack = this.stack().peek(nargs - 1 - i);
                Type fromDesc = argtypes[i];
                if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                    fromDesc = Type.INT;
                }
                if (fromStack.equals(fromDesc)) continue;
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                    this.referenceTypeIsInitialized(o, rFromStack);
                    continue;
                }
                this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
            }
            Type objref = this.stack().peek(nargs);
            if (objref == Type.NULL) {
                return;
            }
            if (!(objref instanceof ReferenceType)) {
                this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
            }
            this.referenceTypeIsInitialized(o, (ReferenceType)objref);
            if (!(objref instanceof ObjectType)) {
                if (!(objref instanceof ArrayType)) {
                    this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
                } else {
                    objref = GENERIC_ARRAY;
                }
            }
            if (!Repository.instanceOf(objref_classname = ((ObjectType)objref).getClassName(), theClass = o.getClassName(this.cpg))) {
                this.constraintViolated(o, "The 'objref' item '" + objref + "' does not implement '" + theClass + "' as expected.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitIOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IREM o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IRETURN o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitISHL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ISHL o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitISHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ISHR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitISTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ISTORE o) {
    }

    @Override
    public void visitISUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ISUB o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIUSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IUSHR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIXOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IXOR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitJSR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JSR o) {
    }

    @Override
    public void visitJSR_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JSR_W o) {
    }

    @Override
    public void visitL2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString L2D o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitL2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString L2F o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitL2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString L2I o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LADD o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.LONG) {
            this.constraintViolated(o, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLAND(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LAND o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LASTORE o) {
        Type t;
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.LONG) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitLCMP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LCMP o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LCONST o) {
    }

    @Override
    public void visitLDC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDC o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString || c instanceof ConstantClass)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float, a CONSTANT_String or a CONSTANT_Class, but is '" + c + "'.");
        }
    }

    public void visitLDC_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDC_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString || c instanceof ConstantClass)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float, a CONSTANT_String or a CONSTANT_Class, but is '" + c + "'.");
        }
    }

    @Override
    public void visitLDC2_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDC2_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantLong) && !(c instanceof ConstantDouble)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c + "'.");
        }
    }

    @Override
    public void visitLDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDIV o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LLOAD o) {
    }

    @Override
    public void visitLMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LMUL o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LNEG o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLOOKUPSWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LOOKUPSWITCH o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LOR o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LREM o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LRETURN o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLSHL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LSHL o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LSHR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LSTORE o) {
    }

    @Override
    public void visitLSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LSUB o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLUSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LUSHR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLXOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LXOR o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitMONITORENTER(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MONITORENTER o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitMONITOREXIT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MONITOREXIT o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitMULTIANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MULTIANEWARRAY o) {
        int dimensions = o.getDimensions();
        for (int i = 0; i < dimensions; ++i) {
            if (this.stack().peek(i) == Type.INT) continue;
            this.constraintViolated(o, "The '" + dimensions + "' upper stack types should be 'int' but aren't.");
        }
    }

    @Override
    public void visitNEW(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString NEW o) {
        Type t = o.getType(this.cpg);
        if (!(t instanceof ReferenceType)) {
            throw new AssertionViolatedException("NEW.getType() returning a non-reference type?!");
        }
        if (!(t instanceof ObjectType)) {
            this.constraintViolated(o, "Expecting a class type (ObjectType) to work on. Found: '" + t + "'.");
        }
        ObjectType obj = (ObjectType)t;
        try {
            if (!obj.referencesClassExact()) {
                this.constraintViolated(o, "Expecting a class type (ObjectType) to work on. Found: '" + obj + "'.");
            }
        }
        catch (ClassNotFoundException e) {
            this.constraintViolated(o, "Expecting a class type (ObjectType) to work on. Found: '" + obj + "'." + " which threw " + e);
        }
    }

    @Override
    public void visitNEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString NEWARRAY o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitNOP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString NOP o) {
    }

    @Override
    public void visitPOP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString POP o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Stack top size should be 1 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    @Override
    public void visitPOP2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString POP2 o) {
        if (this.stack().peek().getSize() != 2) {
            this.constraintViolated(o, "Stack top size should be 2 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    @Override
    public void visitPUTFIELD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString PUTFIELD o) {
        try {
            ObjectType curr;
            ObjectType classtype;
            Type objectref = this.stack().peek(1);
            if (!(objectref instanceof ObjectType) && objectref != Type.NULL) {
                this.constraintViolated(o, "Stack next-to-top should be an object reference that's not an array reference, but is '" + objectref + "'.");
            }
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
            Field[] fields = jc.getFields();
            FieldOrMethod f = null;
            for (Field field : fields) {
                Type o_type;
                Type f_type;
                if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.cpg))) continue;
                f = field;
                break;
            }
            if (f == null) {
                throw new AssertionViolatedException("Field '" + field_name + "' not found in " + jc.getClassName());
            }
            Type value = this.stack().peek();
            Type t = Type.getType(f.getSignature());
            Type shouldbe = t;
            if (shouldbe == Type.BOOLEAN || shouldbe == Type.BYTE || shouldbe == Type.CHAR || shouldbe == Type.SHORT) {
                shouldbe = Type.INT;
            }
            if (t instanceof ReferenceType) {
                ReferenceType rvalue = null;
                if (value instanceof ReferenceType) {
                    rvalue = (ReferenceType)value;
                    this.referenceTypeIsInitialized(o, rvalue);
                } else {
                    this.constraintViolated(o, "The stack top type '" + value + "' is not of a reference type as expected.");
                }
                if (!rvalue.isAssignmentCompatibleWith(shouldbe)) {
                    this.constraintViolated(o, "The stack top type '" + value + "' is not assignment compatible with '" + shouldbe + "'.");
                }
            } else if (shouldbe != value) {
                this.constraintViolated(o, "The stack top type '" + value + "' is not of type '" + shouldbe + "' as expected.");
            }
            if (f.isProtected() && ((classtype = this.getObjectType(o)).equals(curr = ObjectType.getInstance(this.mg.getClassName())) || curr.subclassOf(classtype))) {
                ObjectType objreftype;
                Type tp = this.stack().peek(1);
                if (tp == Type.NULL) {
                    return;
                }
                if (!(tp instanceof ObjectType)) {
                    this.constraintViolated(o, "The 'objectref' must refer to an object that's not an array. Found instead: '" + tp + "'.");
                }
                if (!(objreftype = (ObjectType)tp).equals(curr) && !objreftype.subclassOf(curr)) {
                    this.constraintViolated(o, "The referenced field has the ACC_PROTECTED modifier, and it's a member of the current class or a superclass of the current class. However, the referenced object type '" + this.stack().peek() + "' is not the current class or a subclass of the current class.");
                }
            }
            if (f.isStatic()) {
                this.constraintViolated(o, "Referenced field '" + f + "' is static which it shouldn't be.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitPUTSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString PUTSTATIC o) {
        try {
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
            Field[] fields = jc.getFields();
            FieldOrMethod f = null;
            for (Field field : fields) {
                Type o_type;
                Type f_type;
                if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.cpg))) continue;
                f = field;
                break;
            }
            if (f == null) {
                throw new AssertionViolatedException("Field '" + field_name + "' not found in " + jc.getClassName());
            }
            Type value = this.stack().peek();
            Type t = Type.getType(f.getSignature());
            Type shouldbe = t;
            if (shouldbe == Type.BOOLEAN || shouldbe == Type.BYTE || shouldbe == Type.CHAR || shouldbe == Type.SHORT) {
                shouldbe = Type.INT;
            }
            if (t instanceof ReferenceType) {
                ReferenceType rvalue = null;
                if (value instanceof ReferenceType) {
                    rvalue = (ReferenceType)value;
                    this.referenceTypeIsInitialized(o, rvalue);
                } else {
                    this.constraintViolated(o, "The stack top type '" + value + "' is not of a reference type as expected.");
                }
                if (!rvalue.isAssignmentCompatibleWith(shouldbe)) {
                    this.constraintViolated(o, "The stack top type '" + value + "' is not assignment compatible with '" + shouldbe + "'.");
                }
            } else if (shouldbe != value) {
                this.constraintViolated(o, "The stack top type '" + value + "' is not of type '" + shouldbe + "' as expected.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitRET(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString RET o) {
        if (!(this.locals().get(o.getIndex()) instanceof ReturnaddressType)) {
            this.constraintViolated(o, "Expecting a ReturnaddressType in local variable " + o.getIndex() + ".");
        }
        if (this.locals().get(o.getIndex()) == ReturnaddressType.NO_TARGET) {
            throw new AssertionViolatedException("Oops: RET expecting a target!");
        }
    }

    @Override
    public void visitRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString RETURN o) {
        if (this.mg.getName().equals("<init>") && Frame.getThis() != null && !this.mg.getClassName().equals(Type.OBJECT.getClassName())) {
            this.constraintViolated(o, "Leaving a constructor that itself did not call a constructor.");
        }
    }

    @Override
    public void visitSALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(o, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitSASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SASTORE o) {
        Type t;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitSIPUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SIPUSH o) {
    }

    @Override
    public void visitSWAP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SWAP o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "The value at the stack top is not of size '1', but of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of size '1', but of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    @Override
    public void visitTABLESWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString TABLESWITCH o) {
        this.indexOfInt(o, this.stack().peek());
    }
}

