/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier.structurals;

import afu.org.apache.commons.bcel6.generic.ATHROW;
import afu.org.apache.commons.bcel6.generic.BranchInstruction;
import afu.org.apache.commons.bcel6.generic.GotoInstruction;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.InstructionHandle;
import afu.org.apache.commons.bcel6.generic.JsrInstruction;
import afu.org.apache.commons.bcel6.generic.MethodGen;
import afu.org.apache.commons.bcel6.generic.RET;
import afu.org.apache.commons.bcel6.generic.ReturnInstruction;
import afu.org.apache.commons.bcel6.generic.Select;
import afu.org.apache.commons.bcel6.verifier.exc.AssertionViolatedException;
import afu.org.apache.commons.bcel6.verifier.exc.StructuralCodeConstraintException;
import afu.org.apache.commons.bcel6.verifier.structurals.ExceptionHandler;
import afu.org.apache.commons.bcel6.verifier.structurals.ExceptionHandlers;
import afu.org.apache.commons.bcel6.verifier.structurals.ExecutionVisitor;
import afu.org.apache.commons.bcel6.verifier.structurals.Frame;
import afu.org.apache.commons.bcel6.verifier.structurals.InstConstraintVisitor;
import afu.org.apache.commons.bcel6.verifier.structurals.InstructionContext;
import afu.org.apache.commons.bcel6.verifier.structurals.LocalVariables;
import afu.org.apache.commons.bcel6.verifier.structurals.OperandStack;
import afu.org.apache.commons.bcel6.verifier.structurals.Subroutine;
import afu.org.apache.commons.bcel6.verifier.structurals.Subroutines;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControlFlowGraph {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Subroutines subroutines;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ExceptionHandlers exceptionhandlers;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionContext> instructionContexts = new HashMap<InstructionHandle, InstructionContext>();

    public ControlFlowGraph(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MethodGen method_gen) {
        this(method_gen, true);
    }

    public ControlFlowGraph(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MethodGen method_gen, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean enableJustIceCheck) {
        InstructionHandle[] instructionhandles;
        this.subroutines = new Subroutines(method_gen, enableJustIceCheck);
        this.exceptionhandlers = new ExceptionHandlers(method_gen);
        for (InstructionHandle instructionhandle : instructionhandles = method_gen.getInstructionList().getInstructionHandles()) {
            this.instructionContexts.put(instructionhandle, new InstructionContextImpl(instructionhandle));
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionContext contextOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle inst) {
        InstructionContext ic = this.instructionContexts.get(inst);
        if (ic == null) {
            throw new AssertionViolatedException("InstructionContext requested for an InstructionHandle that's not known!");
        }
        return ic;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionContext @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] contextsOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] insts) {
        InstructionContext[] ret = new InstructionContext[insts.length];
        for (int i = 0; i < insts.length; ++i) {
            ret[i] = this.contextOf(insts[i]);
        }
        return ret;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionContext @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getInstructionContexts() {
        InstructionContext[] ret = new InstructionContext[this.instructionContexts.values().size()];
        return this.instructionContexts.values().toArray(ret);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isDead(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle i) {
        return this.subroutines.subroutineOf(i) == null;
    }

    private class InstructionContextImpl
    implements InstructionContext {
        private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int TAG;
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle instruction;
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionContext, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Frame> inFrames;
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionContext, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Frame> outFrames;
        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionContext> executionPredecessors = null;

        public InstructionContextImpl(InstructionHandle inst) {
            if (inst == null) {
                throw new AssertionViolatedException("Cannot instantiate InstructionContextImpl from NULL.");
            }
            this.instruction = inst;
            this.inFrames = new HashMap<InstructionContext, Frame>();
            this.outFrames = new HashMap<InstructionContext, Frame>();
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTag() {
            return this.TAG;
        }

        @Override
        public void setTag(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int tag) {
            this.TAG = tag;
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ExceptionHandler @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getExceptionHandlers() {
            return ControlFlowGraph.this.exceptionhandlers.getExceptionHandlers(this.getInstruction());
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Frame getOutFrame(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ArrayList<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionContext> execChain) {
            this.executionPredecessors = execChain;
            InstructionContextImpl jsr = this.lastExecutionJSR();
            Frame org = this.outFrames.get(jsr);
            if (org == null) {
                throw new AssertionViolatedException("outFrame not set! This:\n" + this + "\nExecutionChain: " + this.getExecutionChain() + "\nOutFrames: '" + this.outFrames + "'.");
            }
            return org.getClone();
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Frame getInFrame() {
            InstructionContextImpl jsr = this.lastExecutionJSR();
            Frame org = this.inFrames.get(jsr);
            if (org == null) {
                throw new AssertionViolatedException("inFrame not set! This:\n" + this + "\nInFrames: '" + this.inFrames + "'.");
            }
            return org.getClone();
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean execute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Frame inFrame, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ArrayList<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionContext> execPreds, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstConstraintVisitor icv, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ExecutionVisitor ev) {
            List clone;
            this.executionPredecessors = clone = (List)execPreds.clone();
            if (this.lastExecutionJSR() == null && ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction()) != ControlFlowGraph.this.subroutines.getTopLevel()) {
                throw new AssertionViolatedException("Huh?! Am I '" + this + "' part of a subroutine or not?");
            }
            if (this.lastExecutionJSR() != null && ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction()) == ControlFlowGraph.this.subroutines.getTopLevel()) {
                throw new AssertionViolatedException("Huh?! Am I '" + this + "' part of a subroutine or not?");
            }
            Frame inF = this.inFrames.get(this.lastExecutionJSR());
            if (inF == null) {
                this.inFrames.put(this.lastExecutionJSR(), inFrame);
                inF = inFrame;
            } else {
                if (inF.equals(inFrame)) {
                    return false;
                }
                if (!this.mergeInFrames(inFrame)) {
                    return false;
                }
            }
            Frame workingFrame = inF.getClone();
            try {
                icv.setFrame(workingFrame);
                this.getInstruction().accept(icv);
            }
            catch (StructuralCodeConstraintException ce) {
                ce.extendMessage("", "\nInstructionHandle: " + this.getInstruction() + "\n");
                ce.extendMessage("", "\nExecution Frame:\n" + workingFrame);
                this.extendMessageWithFlow(ce);
                throw ce;
            }
            ev.setFrame(workingFrame);
            this.getInstruction().accept(ev);
            this.outFrames.put(this.lastExecutionJSR(), workingFrame);
            return true;
        }

        @SideEffectFree
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
            String ret = this.getInstruction().toString(false) + "\t[InstructionContext]";
            return ret;
        }

        private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean mergeInFrames(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Frame inFrame) {
            Frame inF = this.inFrames.get(this.lastExecutionJSR());
            OperandStack oldstack = inF.getStack().getClone();
            LocalVariables oldlocals = inF.getLocals().getClone();
            try {
                inF.getStack().merge(inFrame.getStack());
                inF.getLocals().merge(inFrame.getLocals());
            }
            catch (StructuralCodeConstraintException sce) {
                this.extendMessageWithFlow(sce);
                throw sce;
            }
            return !oldstack.equals(inF.getStack()) || !oldlocals.equals(inF.getLocals());
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getExecutionChain() {
            String s2 = this.toString();
            for (int i = this.executionPredecessors.size() - 1; i >= 0; --i) {
                s2 = this.executionPredecessors.get(i) + "\n" + s2;
            }
            return s2;
        }

        private void extendMessageWithFlow(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StructuralCodeConstraintException e) {
            String s2 = "Execution flow:\n";
            e.extendMessage("", s2 + this.getExecutionChain());
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getInstruction() {
            return this.instruction;
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ControlFlowGraph.InstructionContextImpl lastExecutionJSR() {
            int size = this.executionPredecessors.size();
            int retcount = 0;
            for (int i = size - 1; i >= 0; --i) {
                InstructionContextImpl current = (InstructionContextImpl)this.executionPredecessors.get(i);
                Instruction currentlast = current.getInstruction().getInstruction();
                if (currentlast instanceof RET) {
                    ++retcount;
                }
                if (!(currentlast instanceof JsrInstruction) || --retcount != -1) continue;
                return current;
            }
            return null;
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionContext @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getSuccessors() {
            return ControlFlowGraph.this.contextsOf(this._getSuccessors());
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] _getSuccessors() {
            InstructionHandle[] empty = new InstructionHandle[]{};
            InstructionHandle[] single = new InstructionHandle[1];
            Instruction inst = this.getInstruction().getInstruction();
            if (inst instanceof RET) {
                Subroutine s2 = ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction());
                if (s2 == null) {
                    throw new AssertionViolatedException("Asking for successors of a RET in dead code?!");
                }
                InstructionHandle[] jsrs = s2.getEnteringJsrInstructions();
                InstructionHandle[] ret = new InstructionHandle[jsrs.length];
                for (int i = 0; i < jsrs.length; ++i) {
                    ret[i] = jsrs[i].getNext();
                }
                return ret;
            }
            if (inst instanceof ReturnInstruction) {
                return empty;
            }
            if (inst instanceof ATHROW) {
                return empty;
            }
            if (inst instanceof JsrInstruction) {
                single[0] = ((JsrInstruction)inst).getTarget();
                return single;
            }
            if (inst instanceof GotoInstruction) {
                single[0] = ((GotoInstruction)inst).getTarget();
                return single;
            }
            if (inst instanceof BranchInstruction) {
                if (inst instanceof Select) {
                    InstructionHandle[] matchTargets = ((Select)inst).getTargets();
                    InstructionHandle[] ret = new InstructionHandle[matchTargets.length + 1];
                    ret[0] = ((Select)inst).getTarget();
                    System.arraycopy(matchTargets, 0, ret, 1, matchTargets.length);
                    return ret;
                }
                InstructionHandle[] pair = new InstructionHandle[]{this.getInstruction().getNext(), ((BranchInstruction)inst).getTarget()};
                return pair;
            }
            single[0] = this.getInstruction().getNext();
            return single;
        }
    }
}

