/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier;

import afu.org.apache.commons.bcel6.Repository;
import afu.org.apache.commons.bcel6.classfile.JavaClass;
import afu.org.apache.commons.bcel6.verifier.VerificationResult;
import afu.org.apache.commons.bcel6.verifier.Verifier;
import afu.org.apache.commons.bcel6.verifier.VerifierFactory;
import afu.org.apache.commons.bcel6.verifier.VerifierFactoryObserver;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;

public class TransitiveHull
implements VerifierFactoryObserver {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int indent = 0;

    private TransitiveHull() {
    }

    @Override
    public void update(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String classname) {
        System.gc();
        for (int i = 0; i < this.indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(classname);
        ++this.indent;
        Verifier v = VerifierFactory.getVerifier(classname);
        VerificationResult vr = v.doPass1();
        if (vr != VerificationResult.VR_OK) {
            System.out.println("Pass 1:\n" + vr);
        }
        if ((vr = v.doPass2()) != VerificationResult.VR_OK) {
            System.out.println("Pass 2:\n" + vr);
        }
        if (vr == VerificationResult.VR_OK) {
            try {
                JavaClass jc = Repository.lookupClass(v.getClassName());
                for (int i = 0; i < jc.getMethods().length; ++i) {
                    vr = v.doPass3a(i);
                    if (vr != VerificationResult.VR_OK) {
                        System.out.println(v.getClassName() + ", Pass 3a, method " + i + " ['" + jc.getMethods()[i] + "']:\n" + vr);
                    }
                    if ((vr = v.doPass3b(i)) == VerificationResult.VR_OK) continue;
                    System.out.println(v.getClassName() + ", Pass 3b, method " + i + " ['" + jc.getMethods()[i] + "']:\n" + vr);
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("Could not find class " + v.getClassName() + " in Repository");
            }
        }
        --this.indent;
    }

    public static void main(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] args) {
        int dotclasspos;
        if (args.length != 1) {
            System.out.println("Need exactly one argument: The root class to verify.");
            System.exit(1);
        }
        if ((dotclasspos = args[0].lastIndexOf(".class")) != -1) {
            args[0] = args[0].substring(0, dotclasspos);
        }
        args[0] = args[0].replace('/', '.');
        TransitiveHull th = new TransitiveHull();
        VerifierFactory.attach(th);
        VerifierFactory.getVerifier(args[0]);
        VerifierFactory.detach(th);
    }
}

