/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.util;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.generic.AllocationInstruction;
import afu.org.apache.commons.bcel6.generic.ArrayInstruction;
import afu.org.apache.commons.bcel6.generic.ArrayType;
import afu.org.apache.commons.bcel6.generic.BranchHandle;
import afu.org.apache.commons.bcel6.generic.BranchInstruction;
import afu.org.apache.commons.bcel6.generic.CHECKCAST;
import afu.org.apache.commons.bcel6.generic.CPInstruction;
import afu.org.apache.commons.bcel6.generic.CodeExceptionGen;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.ConstantPushInstruction;
import afu.org.apache.commons.bcel6.generic.EmptyVisitor;
import afu.org.apache.commons.bcel6.generic.FieldInstruction;
import afu.org.apache.commons.bcel6.generic.IINC;
import afu.org.apache.commons.bcel6.generic.INSTANCEOF;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.InstructionConst;
import afu.org.apache.commons.bcel6.generic.InstructionHandle;
import afu.org.apache.commons.bcel6.generic.InvokeInstruction;
import afu.org.apache.commons.bcel6.generic.LDC;
import afu.org.apache.commons.bcel6.generic.LDC2_W;
import afu.org.apache.commons.bcel6.generic.LocalVariableInstruction;
import afu.org.apache.commons.bcel6.generic.MULTIANEWARRAY;
import afu.org.apache.commons.bcel6.generic.MethodGen;
import afu.org.apache.commons.bcel6.generic.NEWARRAY;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.RET;
import afu.org.apache.commons.bcel6.generic.ReturnInstruction;
import afu.org.apache.commons.bcel6.generic.Select;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.util.BCELifier;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class BCELFactory
extends EmptyVisitor {
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String CONSTANT_PREFIX = Const.class.getSimpleName() + ".";
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MethodGen _mg;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString PrintWriter _out;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen _cp;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle> branch_map = new HashMap<Instruction, InstructionHandle>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BranchInstruction> branches = new ArrayList<BranchInstruction>();

    BCELFactory(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MethodGen mg, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString PrintWriter out) {
        this._mg = mg;
        this._cp = mg.getConstantPool();
        this._out = out;
    }

    public void start() {
        if (!this._mg.isAbstract() && !this._mg.isNative()) {
            for (InstructionHandle ih = this._mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (i instanceof BranchInstruction) {
                    this.branch_map.put(i, ih);
                }
                if (ih.hasTargeters()) {
                    if (i instanceof BranchInstruction) {
                        this._out.println("    InstructionHandle ih_" + ih.getPosition() + ";");
                    } else {
                        this._out.print("    InstructionHandle ih_" + ih.getPosition() + " = ");
                    }
                } else {
                    this._out.print("    ");
                }
                if (this.visitInstruction(i)) continue;
                i.accept(this);
            }
            this.updateBranchTargets();
            this.updateExceptionHandlers();
        }
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean visitInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction i) {
        short opcode = i.getOpcode();
        if (InstructionConst.getInstruction(opcode) != null && !(i instanceof ConstantPushInstruction) && !(i instanceof ReturnInstruction)) {
            this._out.println("il.append(InstructionConst." + i.getName().toUpperCase(Locale.ENGLISH) + ");");
            return true;
        }
        return false;
    }

    @Override
    public void visitLocalVariableInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariableInstruction i) {
        short opcode = i.getOpcode();
        Type type = i.getType(this._cp);
        if (opcode == 132) {
            this._out.println("il.append(new IINC(" + i.getIndex() + ", " + ((IINC)i).getIncrement() + "));");
        } else {
            String kind = opcode < 54 ? "Load" : "Store";
            this._out.println("il.append(_factory.create" + kind + "(" + BCELifier.printType(type) + ", " + i.getIndex() + "));");
        }
    }

    @Override
    public void visitArrayInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ArrayInstruction i) {
        short opcode = i.getOpcode();
        Type type = i.getType(this._cp);
        String kind = opcode < 79 ? "Load" : "Store";
        this._out.println("il.append(_factory.createArray" + kind + "(" + BCELifier.printType(type) + "));");
    }

    @Override
    public void visitFieldInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FieldInstruction i) {
        short opcode = i.getOpcode();
        String class_name = i.getClassName(this._cp);
        String field_name = i.getFieldName(this._cp);
        Type type = i.getFieldType(this._cp);
        this._out.println("il.append(_factory.createFieldAccess(\"" + class_name + "\", \"" + field_name + "\", " + BCELifier.printType(type) + ", " + CONSTANT_PREFIX + Const.getOpcodeName(opcode).toUpperCase(Locale.ENGLISH) + "));");
    }

    @Override
    public void visitInvokeInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InvokeInstruction i) {
        short opcode = i.getOpcode();
        String class_name = i.getClassName(this._cp);
        String method_name = i.getMethodName(this._cp);
        Type type = i.getReturnType(this._cp);
        Type[] arg_types = i.getArgumentTypes(this._cp);
        this._out.println("il.append(_factory.createInvoke(\"" + class_name + "\", \"" + method_name + "\", " + BCELifier.printType(type) + ", " + BCELifier.printArgumentTypes(arg_types) + ", " + CONSTANT_PREFIX + Const.getOpcodeName(opcode).toUpperCase(Locale.ENGLISH) + "));");
    }

    @Override
    public void visitAllocationInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AllocationInstruction i) {
        Type type = i instanceof CPInstruction ? ((CPInstruction)((Object)i)).getType(this._cp) : ((NEWARRAY)i).getType();
        short opcode = ((Instruction)((Object)i)).getOpcode();
        short dim = 1;
        switch (opcode) {
            case 187: {
                this._out.println("il.append(_factory.createNew(\"" + ((ObjectType)type).getClassName() + "\"));");
                break;
            }
            case 197: {
                dim = ((MULTIANEWARRAY)i).getDimensions();
            }
            case 188: 
            case 189: {
                if (type instanceof ArrayType) {
                    type = ((ArrayType)type).getBasicType();
                }
                this._out.println("il.append(_factory.createNewArray(" + BCELifier.printType(type) + ", (short) " + dim + "));");
                break;
            }
            default: {
                throw new RuntimeException("Oops: " + opcode);
            }
        }
    }

    private void createConstant(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object value) {
        String embed = value.toString();
        if (value instanceof String) {
            embed = '\"' + Utility.convertString(embed) + '\"';
        } else if (value instanceof Character) {
            embed = "(char)0x" + Integer.toHexString(((Character)value).charValue());
        } else if (value instanceof Float) {
            embed = embed + "f";
        } else if (value instanceof Long) {
            embed = embed + "L";
        } else if (value instanceof ObjectType) {
            ObjectType ot = (ObjectType)value;
            embed = "new ObjectType(\"" + ot.getClassName() + "\")";
        }
        this._out.println("il.append(new PUSH(_cp, " + embed + "));");
    }

    @Override
    public void visitLDC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDC i) {
        this.createConstant(i.getValue(this._cp));
    }

    @Override
    public void visitLDC2_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDC2_W i) {
        this.createConstant(i.getValue(this._cp));
    }

    @Override
    public void visitConstantPushInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPushInstruction i) {
        this.createConstant(i.getValue());
    }

    @Override
    public void visitINSTANCEOF(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INSTANCEOF i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(new INSTANCEOF(_cp.addClass(" + BCELifier.printType(type) + ")));");
    }

    @Override
    public void visitCHECKCAST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CHECKCAST i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(_factory.createCheckCast(" + BCELifier.printType(type) + "));");
    }

    @Override
    public void visitReturnInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ReturnInstruction i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(_factory.createReturn(" + BCELifier.printType(type) + "));");
    }

    @Override
    public void visitBranchInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BranchInstruction bi) {
        BranchHandle bh = (BranchHandle)this.branch_map.get(bi);
        int pos = bh.getPosition();
        String name = bi.getName() + "_" + pos;
        if (bi instanceof Select) {
            int i;
            Select s2 = (Select)bi;
            this.branches.add(bi);
            StringBuilder args = new StringBuilder("new int[] { ");
            int[] matchs = s2.getMatchs();
            for (i = 0; i < matchs.length; ++i) {
                args.append(matchs[i]);
                if (i >= matchs.length - 1) continue;
                args.append(", ");
            }
            args.append(" }");
            this._out.print("Select " + name + " = new " + bi.getName().toUpperCase(Locale.ENGLISH) + "(" + args + ", new InstructionHandle[] { ");
            for (i = 0; i < matchs.length; ++i) {
                this._out.print("null");
                if (i >= matchs.length - 1) continue;
                this._out.print(", ");
            }
            this._out.println(" }, null);");
        } else {
            String target;
            int t_pos = bh.getTarget().getPosition();
            if (pos > t_pos) {
                target = "ih_" + t_pos;
            } else {
                this.branches.add(bi);
                target = "null";
            }
            this._out.println("    BranchInstruction " + name + " = _factory.createBranchInstruction(" + CONSTANT_PREFIX + bi.getName().toUpperCase(Locale.ENGLISH) + ", " + target + ");");
        }
        if (bh.hasTargeters()) {
            this._out.println("    ih_" + pos + " = il.append(" + name + ");");
        } else {
            this._out.println("    il.append(" + name + ");");
        }
    }

    @Override
    public void visitRET(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString RET i) {
        this._out.println("il.append(new RET(" + i.getIndex() + ")));");
    }

    private void updateBranchTargets() {
        for (BranchInstruction bi : this.branches) {
            BranchHandle bh = (BranchHandle)this.branch_map.get(bi);
            int pos = bh.getPosition();
            String name = bi.getName() + "_" + pos;
            int t_pos = bh.getTarget().getPosition();
            this._out.println("    " + name + ".setTarget(ih_" + t_pos + ");");
            if (!(bi instanceof Select)) continue;
            InstructionHandle[] ihs = ((Select)bi).getTargets();
            for (int j = 0; j < ihs.length; ++j) {
                t_pos = ihs[j].getPosition();
                this._out.println("    " + name + ".setTarget(" + j + ", ih_" + t_pos + ");");
            }
        }
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] handlers;
        for (CodeExceptionGen h2 : handlers = this._mg.getExceptionHandlers()) {
            String type = h2.getCatchType() == null ? "null" : BCELifier.printType(h2.getCatchType());
            this._out.println("    method.addExceptionHandler(ih_" + h2.getStartPC().getPosition() + ", " + "ih_" + h2.getEndPC().getPosition() + ", " + "ih_" + h2.getHandlerPC().getPosition() + ", " + type + ");");
        }
    }
}

