/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.ConstantDouble;
import afu.org.apache.commons.bcel6.classfile.ConstantFloat;
import afu.org.apache.commons.bcel6.classfile.ConstantInteger;
import afu.org.apache.commons.bcel6.classfile.ConstantLong;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ElementValue;
import afu.org.apache.commons.bcel6.classfile.SimpleElementValue;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.ElementValueGen;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public class SimpleElementValueGen
extends ElementValueGen {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int idx;

    protected SimpleElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int idx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen) {
        super(type, cpGen);
        this.idx = idx;
    }

    public SimpleElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int value) {
        super(type, cpGen);
        this.idx = this.getConstantPool().addInteger(value);
    }

    public SimpleElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString long value) {
        super(type, cpGen);
        this.idx = this.getConstantPool().addLong(value);
    }

    public SimpleElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString double value) {
        super(type, cpGen);
        this.idx = this.getConstantPool().addDouble(value);
    }

    public SimpleElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString float value) {
        super(type, cpGen);
        this.idx = this.getConstantPool().addFloat(value);
    }

    public SimpleElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short value) {
        super(type, cpGen);
        this.idx = this.getConstantPool().addInteger(value);
    }

    public SimpleElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte value) {
        super(type, cpGen);
        this.idx = this.getConstantPool().addInteger(value);
    }

    public SimpleElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString char value) {
        super(type, cpGen);
        this.idx = this.getConstantPool().addInteger(value);
    }

    public SimpleElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean value) {
        super(type, cpGen);
        this.idx = value ? this.getConstantPool().addInteger(1) : this.getConstantPool().addInteger(0);
    }

    public SimpleElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String value) {
        super(type, cpGen);
        this.idx = this.getConstantPool().addUtf8(value);
    }

    public SimpleElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SimpleElementValue value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean copyPoolEntries) {
        super(value.getElementValueType(), cpool);
        if (!copyPoolEntries) {
            this.idx = value.getIndex();
        } else {
            switch (value.getElementValueType()) {
                case 115: {
                    this.idx = cpool.addUtf8(value.getValueString());
                    break;
                }
                case 73: {
                    this.idx = cpool.addInteger(value.getValueInt());
                    break;
                }
                case 66: {
                    this.idx = cpool.addInteger(value.getValueByte());
                    break;
                }
                case 67: {
                    this.idx = cpool.addInteger(value.getValueChar());
                    break;
                }
                case 74: {
                    this.idx = cpool.addLong(value.getValueLong());
                    break;
                }
                case 70: {
                    this.idx = cpool.addFloat(value.getValueFloat());
                    break;
                }
                case 68: {
                    this.idx = cpool.addDouble(value.getValueDouble());
                    break;
                }
                case 90: {
                    if (value.getValueBoolean()) {
                        this.idx = cpool.addInteger(1);
                        break;
                    }
                    this.idx = cpool.addInteger(0);
                    break;
                }
                case 83: {
                    this.idx = cpool.addInteger(value.getValueShort());
                    break;
                }
                default: {
                    throw new RuntimeException("SimpleElementValueGen class does not know how to copy this type " + super.getElementValueType());
                }
            }
        }
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue getElementValue() {
        return new SimpleElementValue(super.getElementValueType(), this.idx, this.getConstantPool().getConstantPool());
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIndex() {
        return this.idx;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getValueString() {
        if (super.getElementValueType() != 115) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 c = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
        return c.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getValueInt() {
        if (super.getElementValueType() != 73) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger c = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
        return c.getBytes();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String stringifyValue() {
        switch (super.getElementValueType()) {
            case 73: {
                ConstantInteger c = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
                return Integer.toString(c.getBytes());
            }
            case 74: {
                ConstantLong j = (ConstantLong)this.getConstantPool().getConstant(this.idx);
                return Long.toString(j.getBytes());
            }
            case 68: {
                ConstantDouble d = (ConstantDouble)this.getConstantPool().getConstant(this.idx);
                return Double.toString(d.getBytes());
            }
            case 70: {
                ConstantFloat f = (ConstantFloat)this.getConstantPool().getConstant(this.idx);
                return Float.toString(f.getBytes());
            }
            case 83: {
                ConstantInteger s2 = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
                return Integer.toString(s2.getBytes());
            }
            case 66: {
                ConstantInteger b = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
                return Integer.toString(b.getBytes());
            }
            case 67: {
                ConstantInteger ch = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
                return Integer.toString(ch.getBytes());
            }
            case 90: {
                ConstantInteger bo = (ConstantInteger)this.getConstantPool().getConstant(this.idx);
                if (bo.getBytes() == 0) {
                    return "false";
                }
                return "true";
            }
            case 115: {
                ConstantUtf8 cu8 = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
                return cu8.getBytes();
            }
        }
        throw new RuntimeException("SimpleElementValueGen class does not know how to stringify type " + super.getElementValueType());
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        dos.writeByte(super.getElementValueType());
        switch (super.getElementValueType()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dos.writeShort(this.idx);
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValueGen doesnt know how to write out type " + super.getElementValueType());
            }
        }
    }
}

