/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.generic.CompoundInstruction;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.InstructionHandle;
import afu.org.apache.commons.bcel6.generic.InstructionList;
import afu.org.apache.commons.bcel6.generic.LOOKUPSWITCH;
import afu.org.apache.commons.bcel6.generic.Select;
import afu.org.apache.commons.bcel6.generic.TABLESWITCH;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;

public final class SWITCH
implements CompoundInstruction {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] match;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] targets;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Select instruction;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int match_length;

    public SWITCH(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] match, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] targets, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle target, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_gap) {
        this.match = (int[])match.clone();
        this.targets = (InstructionHandle[])targets.clone();
        this.match_length = match.length;
        if (this.match_length < 2) {
            this.instruction = new TABLESWITCH(match, targets, target);
        } else {
            this.sort(0, this.match_length - 1);
            if (this.matchIsOrdered(max_gap)) {
                this.fillup(max_gap, target);
                this.instruction = new TABLESWITCH(this.match, this.targets, target);
            } else {
                this.instruction = new LOOKUPSWITCH(this.match, this.targets, target);
            }
        }
    }

    public SWITCH(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] match, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] targets, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle target) {
        this(match, targets, target, 1);
    }

    private void fillup(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_gap, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle target) {
        int max_size = this.match_length + this.match_length * max_gap;
        int[] m_vec = new int[max_size];
        InstructionHandle[] t_vec = new InstructionHandle[max_size];
        int count = 1;
        m_vec[0] = this.match[0];
        t_vec[0] = this.targets[0];
        for (int i = 1; i < this.match_length; ++i) {
            int prev = this.match[i - 1];
            int gap = this.match[i] - prev;
            for (int j = 1; j < gap; ++j) {
                m_vec[count] = prev + j;
                t_vec[count] = target;
                ++count;
            }
            m_vec[count] = this.match[i];
            t_vec[count] = this.targets[i];
            ++count;
        }
        this.match = new int[count];
        this.targets = new InstructionHandle[count];
        System.arraycopy(m_vec, 0, this.match, 0, count);
        System.arraycopy(t_vec, 0, this.targets, 0, count);
    }

    private void sort(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int l, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int r) {
        int i = l;
        int j = r;
        int m3 = this.match[(l + r) / 2];
        while (true) {
            if (this.match[i] < m3) {
                ++i;
                continue;
            }
            while (m3 < this.match[j]) {
                --j;
            }
            if (i <= j) {
                int h2 = this.match[i];
                this.match[i] = this.match[j];
                this.match[j] = h2;
                InstructionHandle h22 = this.targets[i];
                this.targets[i] = this.targets[j];
                this.targets[j] = h22;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            this.sort(l, j);
        }
        if (i < r) {
            this.sort(i, r);
        }
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean matchIsOrdered(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_gap) {
        for (int i = 1; i < this.match_length; ++i) {
            if (this.match[i] - this.match[i - 1] <= max_gap) continue;
            return false;
        }
        return true;
    }

    @Override
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction getInstruction() {
        return this.instruction;
    }
}

