/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.Repository;
import afu.org.apache.commons.bcel6.classfile.JavaClass;
import afu.org.apache.commons.bcel6.generic.ArrayType;
import afu.org.apache.commons.bcel6.generic.BasicType;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;

public abstract class ReferenceType
extends Type {
    protected ReferenceType(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte t, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String s2) {
        super(t, s2);
    }

    ReferenceType() {
        super((byte)14, "<null object>");
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isCastableTo(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type t) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        if (this.equals(Type.NULL)) {
            return t instanceof ReferenceType;
        }
        return this.isAssignmentCompatibleWith(t);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isAssignmentCompatibleWith(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type t) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        if (!(t instanceof ReferenceType)) {
            return false;
        }
        ReferenceType T = (ReferenceType)t;
        if (this.equals(Type.NULL)) {
            return true;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesClassExact()) {
            if (T instanceof ObjectType && ((ObjectType)T).referencesClassExact()) {
                if (this.equals(T)) {
                    return true;
                }
                if (Repository.instanceOf(((ObjectType)this).getClassName(), ((ObjectType)T).getClassName())) {
                    return true;
                }
            }
            if (T instanceof ObjectType && ((ObjectType)T).referencesInterfaceExact() && Repository.implementationOf(((ObjectType)this).getClassName(), ((ObjectType)T).getClassName())) {
                return true;
            }
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterfaceExact()) {
            if (T instanceof ObjectType && ((ObjectType)T).referencesClassExact() && T.equals(Type.OBJECT)) {
                return true;
            }
            if (T instanceof ObjectType && ((ObjectType)T).referencesInterfaceExact()) {
                if (this.equals(T)) {
                    return true;
                }
                if (Repository.implementationOf(((ObjectType)this).getClassName(), ((ObjectType)T).getClassName())) {
                    return true;
                }
            }
        }
        if (this instanceof ArrayType) {
            if (T instanceof ObjectType && ((ObjectType)T).referencesClassExact() && T.equals(Type.OBJECT)) {
                return true;
            }
            if (T instanceof ArrayType) {
                Type sc = ((ArrayType)this).getElementType();
                Type tc = ((ArrayType)T).getElementType();
                if (sc instanceof BasicType && tc instanceof BasicType && sc.equals(tc)) {
                    return true;
                }
                if (tc instanceof ReferenceType && sc instanceof ReferenceType && ((ReferenceType)sc).isAssignmentCompatibleWith(tc)) {
                    return true;
                }
            }
            if (T instanceof ObjectType && ((ObjectType)T).referencesInterfaceExact()) {
                for (String element : Const.getInterfacesImplementedByArrays()) {
                    if (!T.equals(ObjectType.getInstance(element))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ReferenceType getFirstCommonSuperclass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ReferenceType t) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        if (this.equals(Type.NULL)) {
            return t;
        }
        if (t.equals(Type.NULL)) {
            return this;
        }
        if (this.equals(t)) {
            return this;
        }
        if (this instanceof ArrayType && t instanceof ArrayType) {
            ArrayType arrType1 = (ArrayType)this;
            ArrayType arrType2 = (ArrayType)t;
            if (arrType1.getDimensions() == arrType2.getDimensions() && arrType1.getBasicType() instanceof ObjectType && arrType2.getBasicType() instanceof ObjectType) {
                return new ArrayType(((ObjectType)arrType1.getBasicType()).getFirstCommonSuperclass((ObjectType)arrType2.getBasicType()), arrType1.getDimensions());
            }
        }
        if (this instanceof ArrayType || t instanceof ArrayType) {
            return Type.OBJECT;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterfaceExact() || t instanceof ObjectType && ((ObjectType)t).referencesInterfaceExact()) {
            return Type.OBJECT;
        }
        ObjectType thiz = (ObjectType)this;
        ObjectType other = (ObjectType)t;
        JavaClass[] thiz_sups = Repository.getSuperClasses(thiz.getClassName());
        JavaClass[] other_sups = Repository.getSuperClasses(other.getClassName());
        if (thiz_sups == null || other_sups == null) {
            return null;
        }
        JavaClass[] this_sups = new JavaClass[thiz_sups.length + 1];
        JavaClass[] t_sups = new JavaClass[other_sups.length + 1];
        System.arraycopy(thiz_sups, 0, this_sups, 1, thiz_sups.length);
        System.arraycopy(other_sups, 0, t_sups, 1, other_sups.length);
        this_sups[0] = Repository.lookupClass(thiz.getClassName());
        t_sups[0] = Repository.lookupClass(other.getClassName());
        for (JavaClass t_sup : t_sups) {
            for (JavaClass this_sup : this_sups) {
                if (!this_sup.equals(t_sup)) continue;
                return ObjectType.getInstance(this_sup.getClassName());
            }
        }
        return null;
    }

    @Deprecated
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ReferenceType firstCommonSuperclass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ReferenceType t) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        if (this.equals(Type.NULL)) {
            return t;
        }
        if (t.equals(Type.NULL)) {
            return this;
        }
        if (this.equals(t)) {
            return this;
        }
        if (this instanceof ArrayType || t instanceof ArrayType) {
            return Type.OBJECT;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterface() || t instanceof ObjectType && ((ObjectType)t).referencesInterface()) {
            return Type.OBJECT;
        }
        ObjectType thiz = (ObjectType)this;
        ObjectType other = (ObjectType)t;
        JavaClass[] thiz_sups = Repository.getSuperClasses(thiz.getClassName());
        JavaClass[] other_sups = Repository.getSuperClasses(other.getClassName());
        if (thiz_sups == null || other_sups == null) {
            return null;
        }
        JavaClass[] this_sups = new JavaClass[thiz_sups.length + 1];
        JavaClass[] t_sups = new JavaClass[other_sups.length + 1];
        System.arraycopy(thiz_sups, 0, this_sups, 1, thiz_sups.length);
        System.arraycopy(other_sups, 0, t_sups, 1, other_sups.length);
        this_sups[0] = Repository.lookupClass(thiz.getClassName());
        t_sups[0] = Repository.lookupClass(other.getClassName());
        for (JavaClass t_sup : t_sups) {
            for (JavaClass this_sup : this_sups) {
                if (!this_sup.equals(t_sup)) continue;
                return ObjectType.getInstance(this_sup.getClassName());
            }
        }
        return null;
    }
}

