/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.ExceptionConst;
import afu.org.apache.commons.bcel6.generic.AllocationInstruction;
import afu.org.apache.commons.bcel6.generic.ArrayType;
import afu.org.apache.commons.bcel6.generic.BasicType;
import afu.org.apache.commons.bcel6.generic.ExceptionThrower;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.StackProducer;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.generic.Visitor;
import afu.org.apache.commons.bcel6.util.ByteSequence;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.KeyForBottom;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.Nullable;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.SignatureBottom;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower,
StackProducer {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte type;

    NEWARRAY() {
    }

    public NEWARRAY(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte type) {
        super((short)188, (short)2);
        this.type = type;
    }

    public NEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType type) {
        this(type.getType());
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        out.writeByte(super.getOpcode());
        out.writeByte(this.type);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte getTypecode() {
        return this.type;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        return super.toString(verbose) + " " + Const.getTypeName(this.type);
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this.type = bytes.readByte();
        super.setLength(2);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Class<@UnknownInterned @Interned @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnannotatedString @SignatureBottom ?> @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getExceptions() {
        return new Class[]{ExceptionConst.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitStackProducer(this);
        v.visitNEWARRAY(this);
    }
}

