/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.IndexedInstruction;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.generic.TypedInstruction;
import afu.org.apache.commons.bcel6.util.ByteSequence;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class LocalVariableInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int n = -1;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short c_tag = (short)-1;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short canon_tag = (short)-1;

    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide() {
        return this.n > 255;
    }

    LocalVariableInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short canon_tag, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short c_tag) {
        this.canon_tag = canon_tag;
        this.c_tag = c_tag;
    }

    LocalVariableInstruction() {
    }

    protected LocalVariableInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short c_tag, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int n) {
        super(opcode, (short)2);
        this.c_tag = c_tag;
        this.canon_tag = opcode;
        this.setIndex(n);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        if (this.wide()) {
            out.writeByte(196);
        }
        out.writeByte(super.getOpcode());
        if (super.getLength() > 1) {
            if (this.wide()) {
                out.writeShort(this.n);
            } else {
                out.writeByte(this.n);
            }
        }
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        short _opcode = super.getOpcode();
        if (_opcode >= 26 && _opcode <= 45 || _opcode >= 59 && _opcode <= 78) {
            return super.toString(verbose);
        }
        return super.toString(verbose) + " " + this.n;
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        if (wide) {
            this.n = bytes.readUnsignedShort();
            super.setLength(4);
        } else {
            short _opcode = super.getOpcode();
            if (_opcode >= 21 && _opcode <= 25 || _opcode >= 54 && _opcode <= 58) {
                this.n = bytes.readUnsignedByte();
                super.setLength(2);
            } else if (_opcode <= 45) {
                this.n = (_opcode - 26) % 4;
                super.setLength(1);
            } else {
                this.n = (_opcode - 59) % 4;
                super.setLength(1);
            }
        }
    }

    @Override
    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIndex() {
        return this.n;
    }

    @Override
    public void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int n) {
        if (n < 0 || n > 65535) {
            throw new ClassGenException("Illegal value: " + n);
        }
        this.n = n;
        if (n <= 3) {
            super.setOpcode((short)(this.c_tag + n));
            super.setLength(1);
        } else {
            super.setOpcode(this.canon_tag);
            if (this.wide()) {
                super.setLength(4);
            } else {
                super.setLength(2);
            }
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short getCanonicalTag() {
        return this.canon_tag;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp) {
        switch (this.canon_tag) {
            case 21: 
            case 54: {
                return Type.INT;
            }
            case 22: 
            case 55: {
                return Type.LONG;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT;
            }
            case 25: 
            case 58: {
                return Type.OBJECT;
            }
        }
        throw new ClassGenException("Oops: unknown case in switch" + this.canon_tag);
    }

    final void setIndexOnly(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int n) {
        this.n = n;
    }
}

