/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.classfile.Constant;
import afu.org.apache.commons.bcel6.classfile.ConstantCP;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.ExceptionThrower;
import afu.org.apache.commons.bcel6.generic.FieldOrMethod;
import afu.org.apache.commons.bcel6.generic.StackConsumer;
import afu.org.apache.commons.bcel6.generic.StackProducer;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.ClassGetName;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.util.StringTokenizer;

public abstract class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower,
StackConsumer,
StackProducer {
    InvokeInstruction() {
    }

    protected InvokeInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        super(opcode, index);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp) {
        Constant c = cp.getConstant(super.getIndex());
        StringTokenizer tok = new StringTokenizer(cp.constantToString(c));
        return Const.getOpcodeName(super.getOpcode()) + " " + tok.nextToken().replace('.', '/') + tok.nextToken();
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int consumeStack(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        int sum = super.getOpcode() == 184 || super.getOpcode() == 186 ? 0 : 1;
        String signature = this.getSignature(cpg);
        return sum += Type.getArgumentTypesSize(signature);
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int produceStack(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        String signature = this.getSignature(cpg);
        return Type.getReturnTypeSize(signature);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        return this.getReturnType(cpg);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getMethodName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        return this.getName(cpg);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getReturnType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        return Type.getReturnType(this.getSignature(cpg));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getArgumentTypes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        return Type.getArgumentTypes(this.getSignature(cpg));
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @ClassGetName String getClassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP cmr = (ConstantCP)cp.getConstant(super.getIndex());
        String className = cp.getConstantString(cmr.getClassIndex(), (byte)7);
        return className.replace('/', '.');
    }
}

