/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.generic.ALOAD;
import afu.org.apache.commons.bcel6.generic.ANEWARRAY;
import afu.org.apache.commons.bcel6.generic.ASTORE;
import afu.org.apache.commons.bcel6.generic.BIPUSH;
import afu.org.apache.commons.bcel6.generic.BREAKPOINT;
import afu.org.apache.commons.bcel6.generic.CHECKCAST;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.DLOAD;
import afu.org.apache.commons.bcel6.generic.DSTORE;
import afu.org.apache.commons.bcel6.generic.FLOAD;
import afu.org.apache.commons.bcel6.generic.FSTORE;
import afu.org.apache.commons.bcel6.generic.GETFIELD;
import afu.org.apache.commons.bcel6.generic.GETSTATIC;
import afu.org.apache.commons.bcel6.generic.GOTO;
import afu.org.apache.commons.bcel6.generic.GOTO_W;
import afu.org.apache.commons.bcel6.generic.IFEQ;
import afu.org.apache.commons.bcel6.generic.IFGE;
import afu.org.apache.commons.bcel6.generic.IFGT;
import afu.org.apache.commons.bcel6.generic.IFLE;
import afu.org.apache.commons.bcel6.generic.IFLT;
import afu.org.apache.commons.bcel6.generic.IFNE;
import afu.org.apache.commons.bcel6.generic.IFNONNULL;
import afu.org.apache.commons.bcel6.generic.IFNULL;
import afu.org.apache.commons.bcel6.generic.IF_ACMPEQ;
import afu.org.apache.commons.bcel6.generic.IF_ACMPNE;
import afu.org.apache.commons.bcel6.generic.IF_ICMPEQ;
import afu.org.apache.commons.bcel6.generic.IF_ICMPGE;
import afu.org.apache.commons.bcel6.generic.IF_ICMPGT;
import afu.org.apache.commons.bcel6.generic.IF_ICMPLE;
import afu.org.apache.commons.bcel6.generic.IF_ICMPLT;
import afu.org.apache.commons.bcel6.generic.IF_ICMPNE;
import afu.org.apache.commons.bcel6.generic.IINC;
import afu.org.apache.commons.bcel6.generic.ILOAD;
import afu.org.apache.commons.bcel6.generic.IMPDEP1;
import afu.org.apache.commons.bcel6.generic.IMPDEP2;
import afu.org.apache.commons.bcel6.generic.INSTANCEOF;
import afu.org.apache.commons.bcel6.generic.INVOKEDYNAMIC;
import afu.org.apache.commons.bcel6.generic.INVOKEINTERFACE;
import afu.org.apache.commons.bcel6.generic.INVOKESPECIAL;
import afu.org.apache.commons.bcel6.generic.INVOKESTATIC;
import afu.org.apache.commons.bcel6.generic.INVOKEVIRTUAL;
import afu.org.apache.commons.bcel6.generic.ISTORE;
import afu.org.apache.commons.bcel6.generic.InstructionComparator;
import afu.org.apache.commons.bcel6.generic.InstructionConst;
import afu.org.apache.commons.bcel6.generic.JSR;
import afu.org.apache.commons.bcel6.generic.JSR_W;
import afu.org.apache.commons.bcel6.generic.LDC;
import afu.org.apache.commons.bcel6.generic.LDC2_W;
import afu.org.apache.commons.bcel6.generic.LDC_W;
import afu.org.apache.commons.bcel6.generic.LLOAD;
import afu.org.apache.commons.bcel6.generic.LOOKUPSWITCH;
import afu.org.apache.commons.bcel6.generic.LSTORE;
import afu.org.apache.commons.bcel6.generic.LocalVariableInstruction;
import afu.org.apache.commons.bcel6.generic.MULTIANEWARRAY;
import afu.org.apache.commons.bcel6.generic.NEW;
import afu.org.apache.commons.bcel6.generic.NEWARRAY;
import afu.org.apache.commons.bcel6.generic.PUTFIELD;
import afu.org.apache.commons.bcel6.generic.PUTSTATIC;
import afu.org.apache.commons.bcel6.generic.RET;
import afu.org.apache.commons.bcel6.generic.SIPUSH;
import afu.org.apache.commons.bcel6.generic.TABLESWITCH;
import afu.org.apache.commons.bcel6.generic.Visitor;
import afu.org.apache.commons.bcel6.util.ByteSequence;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Instruction
implements Cloneable {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short length = 1;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short opcode = (short)-1;
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionComparator cmp = InstructionComparator.DEFAULT;

    Instruction() {
    }

    public Instruction(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short length) {
        this.length = length;
        this.opcode = opcode;
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        out.writeByte(this.opcode);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getName() {
        return Const.getOpcodeName(this.opcode);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        if (verbose) {
            return this.getName() + "[" + this.opcode + "](" + this.length + ")";
        }
        return this.getName();
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return this.toString(true);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp) {
        return this.toString(false);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction copy() {
        Instruction i = null;
        if (InstructionConst.getInstruction(this.getOpcode()) != null) {
            i = this;
        } else {
            try {
                i = (Instruction)this.clone();
            }
            catch (CloneNotSupportedException e) {
                System.err.println(e);
            }
        }
        return i;
    }

    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction readInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ByteSequence bytes) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        Instruction instruction;
        boolean wide = false;
        short opcode = (short)bytes.readUnsignedByte();
        Instruction obj = null;
        if (opcode == 196) {
            wide = true;
            opcode = (short)bytes.readUnsignedByte();
        }
        if ((instruction = InstructionConst.getInstruction(opcode)) != null) {
            return instruction;
        }
        switch (opcode) {
            case 16: {
                obj = new BIPUSH();
                break;
            }
            case 17: {
                obj = new SIPUSH();
                break;
            }
            case 18: {
                obj = new LDC();
                break;
            }
            case 19: {
                obj = new LDC_W();
                break;
            }
            case 20: {
                obj = new LDC2_W();
                break;
            }
            case 21: {
                obj = new ILOAD();
                break;
            }
            case 22: {
                obj = new LLOAD();
                break;
            }
            case 23: {
                obj = new FLOAD();
                break;
            }
            case 24: {
                obj = new DLOAD();
                break;
            }
            case 25: {
                obj = new ALOAD();
                break;
            }
            case 26: {
                obj = new ILOAD(0);
                break;
            }
            case 27: {
                obj = new ILOAD(1);
                break;
            }
            case 28: {
                obj = new ILOAD(2);
                break;
            }
            case 29: {
                obj = new ILOAD(3);
                break;
            }
            case 30: {
                obj = new LLOAD(0);
                break;
            }
            case 31: {
                obj = new LLOAD(1);
                break;
            }
            case 32: {
                obj = new LLOAD(2);
                break;
            }
            case 33: {
                obj = new LLOAD(3);
                break;
            }
            case 34: {
                obj = new FLOAD(0);
                break;
            }
            case 35: {
                obj = new FLOAD(1);
                break;
            }
            case 36: {
                obj = new FLOAD(2);
                break;
            }
            case 37: {
                obj = new FLOAD(3);
                break;
            }
            case 38: {
                obj = new DLOAD(0);
                break;
            }
            case 39: {
                obj = new DLOAD(1);
                break;
            }
            case 40: {
                obj = new DLOAD(2);
                break;
            }
            case 41: {
                obj = new DLOAD(3);
                break;
            }
            case 42: {
                obj = new ALOAD(0);
                break;
            }
            case 43: {
                obj = new ALOAD(1);
                break;
            }
            case 44: {
                obj = new ALOAD(2);
                break;
            }
            case 45: {
                obj = new ALOAD(3);
                break;
            }
            case 54: {
                obj = new ISTORE();
                break;
            }
            case 55: {
                obj = new LSTORE();
                break;
            }
            case 56: {
                obj = new FSTORE();
                break;
            }
            case 57: {
                obj = new DSTORE();
                break;
            }
            case 58: {
                obj = new ASTORE();
                break;
            }
            case 59: {
                obj = new ISTORE(0);
                break;
            }
            case 60: {
                obj = new ISTORE(1);
                break;
            }
            case 61: {
                obj = new ISTORE(2);
                break;
            }
            case 62: {
                obj = new ISTORE(3);
                break;
            }
            case 63: {
                obj = new LSTORE(0);
                break;
            }
            case 64: {
                obj = new LSTORE(1);
                break;
            }
            case 65: {
                obj = new LSTORE(2);
                break;
            }
            case 66: {
                obj = new LSTORE(3);
                break;
            }
            case 67: {
                obj = new FSTORE(0);
                break;
            }
            case 68: {
                obj = new FSTORE(1);
                break;
            }
            case 69: {
                obj = new FSTORE(2);
                break;
            }
            case 70: {
                obj = new FSTORE(3);
                break;
            }
            case 71: {
                obj = new DSTORE(0);
                break;
            }
            case 72: {
                obj = new DSTORE(1);
                break;
            }
            case 73: {
                obj = new DSTORE(2);
                break;
            }
            case 74: {
                obj = new DSTORE(3);
                break;
            }
            case 75: {
                obj = new ASTORE(0);
                break;
            }
            case 76: {
                obj = new ASTORE(1);
                break;
            }
            case 77: {
                obj = new ASTORE(2);
                break;
            }
            case 78: {
                obj = new ASTORE(3);
                break;
            }
            case 132: {
                obj = new IINC();
                break;
            }
            case 153: {
                obj = new IFEQ();
                break;
            }
            case 154: {
                obj = new IFNE();
                break;
            }
            case 155: {
                obj = new IFLT();
                break;
            }
            case 156: {
                obj = new IFGE();
                break;
            }
            case 157: {
                obj = new IFGT();
                break;
            }
            case 158: {
                obj = new IFLE();
                break;
            }
            case 159: {
                obj = new IF_ICMPEQ();
                break;
            }
            case 160: {
                obj = new IF_ICMPNE();
                break;
            }
            case 161: {
                obj = new IF_ICMPLT();
                break;
            }
            case 162: {
                obj = new IF_ICMPGE();
                break;
            }
            case 163: {
                obj = new IF_ICMPGT();
                break;
            }
            case 164: {
                obj = new IF_ICMPLE();
                break;
            }
            case 165: {
                obj = new IF_ACMPEQ();
                break;
            }
            case 166: {
                obj = new IF_ACMPNE();
                break;
            }
            case 167: {
                obj = new GOTO();
                break;
            }
            case 168: {
                obj = new JSR();
                break;
            }
            case 169: {
                obj = new RET();
                break;
            }
            case 170: {
                obj = new TABLESWITCH();
                break;
            }
            case 171: {
                obj = new LOOKUPSWITCH();
                break;
            }
            case 178: {
                obj = new GETSTATIC();
                break;
            }
            case 179: {
                obj = new PUTSTATIC();
                break;
            }
            case 180: {
                obj = new GETFIELD();
                break;
            }
            case 181: {
                obj = new PUTFIELD();
                break;
            }
            case 182: {
                obj = new INVOKEVIRTUAL();
                break;
            }
            case 183: {
                obj = new INVOKESPECIAL();
                break;
            }
            case 184: {
                obj = new INVOKESTATIC();
                break;
            }
            case 185: {
                obj = new INVOKEINTERFACE();
                break;
            }
            case 186: {
                obj = new INVOKEDYNAMIC();
                break;
            }
            case 187: {
                obj = new NEW();
                break;
            }
            case 188: {
                obj = new NEWARRAY();
                break;
            }
            case 189: {
                obj = new ANEWARRAY();
                break;
            }
            case 192: {
                obj = new CHECKCAST();
                break;
            }
            case 193: {
                obj = new INSTANCEOF();
                break;
            }
            case 197: {
                obj = new MULTIANEWARRAY();
                break;
            }
            case 198: {
                obj = new IFNULL();
                break;
            }
            case 199: {
                obj = new IFNONNULL();
                break;
            }
            case 200: {
                obj = new GOTO_W();
                break;
            }
            case 201: {
                obj = new JSR_W();
                break;
            }
            case 202: {
                obj = new BREAKPOINT();
                break;
            }
            case 254: {
                obj = new IMPDEP1();
                break;
            }
            case 255: {
                obj = new IMPDEP2();
                break;
            }
            default: {
                throw new ClassGenException("Illegal opcode detected: " + opcode);
            }
        }
        if (wide && !(obj instanceof LocalVariableInstruction) && !(obj instanceof IINC) && !(obj instanceof RET)) {
            throw new ClassGenException("Illegal opcode after wide: " + opcode);
        }
        obj.setOpcode(opcode);
        obj.initFromFile(bytes, wide);
        return obj;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int consumeStack(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        return Const.getConsumeStack(this.opcode);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int produceStack(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        return Const.getProduceStack(this.opcode);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short getOpcode() {
        return this.opcode;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getLength() {
        return this.length;
    }

    final void setOpcode(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short opcode) {
        this.opcode = opcode;
    }

    final void setLength(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length) {
        this.length = (short)length;
    }

    void dispose() {
    }

    public abstract void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor var1);

    @Deprecated
    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionComparator getComparator() {
        return cmp;
    }

    @Deprecated
    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionComparator c) {
        cmp = c;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object that) {
        return that instanceof Instruction ? cmp.equals(this, (Instruction)that) : false;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return this.opcode;
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isValidByte(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int value) {
        return value >= -128 && value <= 127;
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isValidShort(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int value) {
        return value >= Short.MIN_VALUE && value <= Short.MAX_VALUE;
    }
}

