/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ElementValue;
import afu.org.apache.commons.bcel6.classfile.EnumElementValue;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.ElementValueGen;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnumElementValueGen
extends ElementValueGen {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int typeIdx;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int valueIdx;

    protected EnumElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int typeIdx, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int valueIdx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool) {
        super(101, cpool);
        if (super.getElementValueType() != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor - type specified: " + super.getElementValueType());
        }
        this.typeIdx = typeIdx;
        this.valueIdx = valueIdx;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue getElementValue() {
        System.err.println("Duplicating value: " + this.getEnumTypeString() + ":" + this.getEnumValueString());
        return new EnumElementValue(super.getElementValueType(), this.typeIdx, this.valueIdx, this.getConstantPool().getConstantPool());
    }

    public EnumElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType t, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool) {
        super(101, cpool);
        this.typeIdx = cpool.addUtf8(t.getSignature());
        this.valueIdx = cpool.addUtf8(value);
    }

    public EnumElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString EnumElementValue value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean copyPoolEntries) {
        super(101, cpool);
        if (copyPoolEntries) {
            this.typeIdx = cpool.addUtf8(value.getEnumTypeString());
            this.valueIdx = cpool.addUtf8(value.getEnumValueString());
        } else {
            this.typeIdx = value.getTypeIndex();
            this.valueIdx = value.getValueIndex();
        }
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        dos.writeByte(super.getElementValueType());
        dos.writeShort(this.typeIdx);
        dos.writeShort(this.valueIdx);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String stringifyValue() {
        ConstantUtf8 cu8 = (ConstantUtf8)this.getConstantPool().getConstant(this.valueIdx);
        return cu8.getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getEnumTypeString() {
        return ((ConstantUtf8)this.getConstantPool().getConstant(this.typeIdx)).getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getEnumValueString() {
        return ((ConstantUtf8)this.getConstantPool().getConstant(this.valueIdx)).getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getValueIndex() {
        return this.valueIdx;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTypeIndex() {
        return this.typeIdx;
    }
}

