/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ElementValue;
import afu.org.apache.commons.bcel6.classfile.ElementValuePair;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.ElementValueGen;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataOutputStream;
import java.io.IOException;

public class ElementValuePairGen {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int nameIdx;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValueGen value;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool;

    public ElementValuePairGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePair nvp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean copyPoolEntries) {
        this.cpool = cpool;
        this.nameIdx = copyPoolEntries ? cpool.addUtf8(nvp.getNameString()) : nvp.getNameIndex();
        this.value = ElementValueGen.copy(nvp.getValue(), cpool, copyPoolEntries);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePair getElementNameValuePair() {
        ElementValue immutableValue = this.value.getElementValue();
        return new ElementValuePair(this.nameIdx, immutableValue, this.cpool.getConstantPool());
    }

    protected ElementValuePairGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int idx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValueGen value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool) {
        this.nameIdx = idx;
        this.value = value;
        this.cpool = cpool;
    }

    public ElementValuePairGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValueGen value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool) {
        this.nameIdx = cpool.addUtf8(name);
        this.value = value;
        this.cpool = cpool;
    }

    protected void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        dos.writeShort(this.nameIdx);
        this.value.dump(dos);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNameIndex() {
        return this.nameIdx;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getNameString() {
        return ((ConstantUtf8)this.cpool.getConstant(this.nameIdx)).getBytes();
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValueGen getValue() {
        return this.value;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return "ElementValuePair:[" + this.getNameString() + "=" + this.value.stringifyValue() + "]";
    }
}

