/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.AnnotationElementValue;
import afu.org.apache.commons.bcel6.classfile.AnnotationEntry;
import afu.org.apache.commons.bcel6.classfile.ArrayElementValue;
import afu.org.apache.commons.bcel6.classfile.ClassElementValue;
import afu.org.apache.commons.bcel6.classfile.ElementValue;
import afu.org.apache.commons.bcel6.classfile.EnumElementValue;
import afu.org.apache.commons.bcel6.classfile.SimpleElementValue;
import afu.org.apache.commons.bcel6.generic.AnnotationElementValueGen;
import afu.org.apache.commons.bcel6.generic.AnnotationEntryGen;
import afu.org.apache.commons.bcel6.generic.ArrayElementValueGen;
import afu.org.apache.commons.bcel6.generic.ClassElementValueGen;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.EnumElementValueGen;
import afu.org.apache.commons.bcel6.generic.SimpleElementValueGen;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ElementValueGen {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int STRING = 115;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int ENUM_CONSTANT = 101;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int CLASS = 99;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int ANNOTATION = 64;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int ARRAY = 91;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int PRIMITIVE_INT = 73;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int PRIMITIVE_BYTE = 66;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int PRIMITIVE_CHAR = 67;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int PRIMITIVE_DOUBLE = 68;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int PRIMITIVE_FLOAT = 70;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int PRIMITIVE_LONG = 74;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int PRIMITIVE_SHORT = 83;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int PRIMITIVE_BOOLEAN = 90;

    protected ElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen) {
        this.type = type;
        this.cpGen = cpGen;
    }

    public abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue getElementValue();

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getElementValueType() {
        return this.type;
    }

    public abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String stringifyValue();

    public abstract void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream var1) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException;

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValueGen readElementValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput dis, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpGen) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        int type = dis.readUnsignedByte();
        switch (type) {
            case 66: {
                return new SimpleElementValueGen(66, dis.readUnsignedShort(), cpGen);
            }
            case 67: {
                return new SimpleElementValueGen(67, dis.readUnsignedShort(), cpGen);
            }
            case 68: {
                return new SimpleElementValueGen(68, dis.readUnsignedShort(), cpGen);
            }
            case 70: {
                return new SimpleElementValueGen(70, dis.readUnsignedShort(), cpGen);
            }
            case 73: {
                return new SimpleElementValueGen(73, dis.readUnsignedShort(), cpGen);
            }
            case 74: {
                return new SimpleElementValueGen(74, dis.readUnsignedShort(), cpGen);
            }
            case 83: {
                return new SimpleElementValueGen(83, dis.readUnsignedShort(), cpGen);
            }
            case 90: {
                return new SimpleElementValueGen(90, dis.readUnsignedShort(), cpGen);
            }
            case 115: {
                return new SimpleElementValueGen(115, dis.readUnsignedShort(), cpGen);
            }
            case 101: {
                return new EnumElementValueGen(dis.readUnsignedShort(), dis.readUnsignedShort(), cpGen);
            }
            case 99: {
                return new ClassElementValueGen(dis.readUnsignedShort(), cpGen);
            }
            case 64: {
                return new AnnotationElementValueGen(64, new AnnotationEntryGen(AnnotationEntry.read(dis, cpGen.getConstantPool(), true), cpGen, false), cpGen);
            }
            case 91: {
                int numArrayVals = dis.readUnsignedShort();
                ElementValue[] evalues = new ElementValue[numArrayVals];
                for (int j = 0; j < numArrayVals; ++j) {
                    evalues[j] = ElementValue.readElementValue(dis, cpGen.getConstantPool());
                }
                return new ArrayElementValueGen(91, evalues, cpGen);
            }
        }
        throw new RuntimeException("Unexpected element value kind in annotation: " + type);
    }

    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen getConstantPool() {
        return this.cpGen;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValueGen copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean copyPoolEntries) {
        switch (value.getElementValueType()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new SimpleElementValueGen((SimpleElementValue)value, cpool, copyPoolEntries);
            }
            case 101: {
                return new EnumElementValueGen((EnumElementValue)value, cpool, copyPoolEntries);
            }
            case 64: {
                return new AnnotationElementValueGen((AnnotationElementValue)value, cpool, copyPoolEntries);
            }
            case 91: {
                return new ArrayElementValueGen((ArrayElementValue)value, cpool, copyPoolEntries);
            }
            case 99: {
                return new ClassElementValueGen((ClassElementValue)value, cpool, copyPoolEntries);
            }
        }
        throw new RuntimeException("Not implemented yet! (" + value.getElementValueType() + ")");
    }
}

