/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.ClassElementValue;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ElementValue;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.ElementValueGen;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClassElementValueGen
extends ElementValueGen {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int idx;

    protected ClassElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int typeIdx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool) {
        super(99, cpool);
        this.idx = typeIdx;
    }

    public ClassElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType t, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool) {
        super(99, cpool);
        this.idx = cpool.addUtf8(t.getSignature());
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue getElementValue() {
        return new ClassElementValue(super.getElementValueType(), this.idx, this.getConstantPool().getConstantPool());
    }

    public ClassElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassElementValue value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean copyPoolEntries) {
        super(99, cpool);
        this.idx = copyPoolEntries ? cpool.addUtf8(value.getClassString()) : value.getIndex();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIndex() {
        return this.idx;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getClassString() {
        ConstantUtf8 cu8 = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
        return cu8.getBytes();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String stringifyValue() {
        return this.getClassString();
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        dos.writeByte(super.getElementValueType());
        dos.writeShort(this.idx);
    }
}

