/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.classfile.Constant;
import afu.org.apache.commons.bcel6.classfile.ConstantClass;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.IndexedInstruction;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.generic.TypedInstruction;
import afu.org.apache.commons.bcel6.util.ByteSequence;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CPInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index;

    CPInstruction() {
    }

    protected CPInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        super(opcode, (short)3);
        this.setIndex(index);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        out.writeByte(super.getOpcode());
        out.writeShort(this.index);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        return super.toString(verbose) + " " + this.index;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        String str = cp.constantToString(c);
        if (c instanceof ConstantClass) {
            str = str.replace('.', '/');
        }
        return Const.getOpcodeName(super.getOpcode()) + " " + str;
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this.setIndex(bytes.readUnsignedShort());
        super.setLength(3);
    }

    @Override
    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        if (index < 0) {
            throw new ClassGenException("Negative index value: " + index);
        }
        this.index = index;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        String name = cp.getConstantString(this.index, (byte)7);
        if (!name.startsWith("[")) {
            name = "L" + name + ";";
        }
        return Type.getType(name);
    }
}

