/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.generic.BasicType;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.ReferenceType;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;

public final class ArrayType
extends ReferenceType {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int dimensions;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type basic_type;

    public ArrayType(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte type, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int dimensions) {
        this(BasicType.getType(type), dimensions);
    }

    public ArrayType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String class_name, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int dimensions) {
        this(ObjectType.getInstance(class_name), dimensions);
    }

    public ArrayType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type type, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int dimensions) {
        super((byte)13, "<dummy>");
        if (dimensions < 1 || dimensions > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + dimensions);
        }
        switch (type.getType()) {
            case 13: {
                ArrayType array = (ArrayType)type;
                this.dimensions = dimensions + array.dimensions;
                this.basic_type = array.basic_type;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = dimensions;
                this.basic_type = type;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.dimensions; ++i) {
            buf.append('[');
        }
        buf.append(this.basic_type.getSignature());
        super.setSignature(buf.toString());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getBasicType() {
        return this.basic_type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getElementType() {
        if (this.dimensions == 1) {
            return this.basic_type;
        }
        return new ArrayType(this.basic_type, this.dimensions - 1);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getDimensions() {
        return this.dimensions;
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return this.basic_type.hashCode() ^ this.dimensions;
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object _type) {
        if (_type instanceof ArrayType) {
            ArrayType array = (ArrayType)_type;
            return array.dimensions == this.dimensions && array.basic_type.equals(this.basic_type);
        }
        return false;
    }
}

