/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.AnnotationEntry;
import afu.org.apache.commons.bcel6.classfile.Annotations;
import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ElementValuePair;
import afu.org.apache.commons.bcel6.classfile.ParameterAnnotations;
import afu.org.apache.commons.bcel6.classfile.RuntimeInvisibleAnnotations;
import afu.org.apache.commons.bcel6.classfile.RuntimeInvisibleParameterAnnotations;
import afu.org.apache.commons.bcel6.classfile.RuntimeVisibleAnnotations;
import afu.org.apache.commons.bcel6.classfile.RuntimeVisibleParameterAnnotations;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.ElementValueGen;
import afu.org.apache.commons.bcel6.generic.ElementValuePairGen;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AnnotationEntryGen {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int typeIndex;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePairGen> evs;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isRuntimeVisible = false;

    public AnnotationEntryGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry a, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean copyPoolEntries) {
        this.cpool = cpool;
        this.typeIndex = copyPoolEntries ? cpool.addUtf8(a.getAnnotationType()) : a.getAnnotationTypeIndex();
        this.isRuntimeVisible = a.isRuntimeVisible();
        this.evs = this.copyValues(a.getElementValuePairs(), cpool, copyPoolEntries);
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePairGen> copyValues(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePair @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] in, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean copyPoolEntries) {
        ArrayList<ElementValuePairGen> out = new ArrayList<ElementValuePairGen>();
        for (ElementValuePair nvp : in) {
            out.add(new ElementValuePairGen(nvp, cpool, copyPoolEntries));
        }
        return out;
    }

    private AnnotationEntryGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool) {
        this.cpool = cpool;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry getAnnotation() {
        AnnotationEntry a = new AnnotationEntry(this.typeIndex, this.cpool.getConstantPool(), this.isRuntimeVisible);
        for (ElementValuePairGen element : this.evs) {
            a.addElementNameValuePair(element.getElementNameValuePair());
        }
        return a;
    }

    public AnnotationEntryGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePairGen> elements, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean vis, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool) {
        this.cpool = cpool;
        this.typeIndex = cpool.addUtf8(type.getSignature());
        this.evs = elements;
        this.isRuntimeVisible = vis;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntryGen read(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput dis, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean b) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        AnnotationEntryGen a = new AnnotationEntryGen(cpool);
        a.typeIndex = dis.readUnsignedShort();
        int elemValuePairCount = dis.readUnsignedShort();
        for (int i = 0; i < elemValuePairCount; ++i) {
            int nidx = dis.readUnsignedShort();
            a.addElementNameValuePair(new ElementValuePairGen(nidx, ElementValueGen.readElementValue(dis, cpool), cpool));
        }
        a.isRuntimeVisible(b);
        return a;
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        dos.writeShort(this.typeIndex);
        dos.writeShort(this.evs.size());
        for (ElementValuePairGen envp : this.evs) {
            envp.dump(dos);
        }
    }

    public void addElementNameValuePair(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePairGen evp) {
        if (this.evs == null) {
            this.evs = new ArrayList<ElementValuePairGen>();
        }
        this.evs.add(evp);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTypeIndex() {
        return this.typeIndex;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getTypeSignature() {
        ConstantUtf8 utf8 = (ConstantUtf8)this.cpool.getConstant(this.typeIndex);
        return utf8.getBytes();
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getTypeName() {
        return this.getTypeSignature();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePairGen> getValues() {
        return this.evs;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder s2 = new StringBuilder(32);
        s2.append("AnnotationGen:[").append(this.getTypeName()).append(" #").append(this.evs.size()).append(" {");
        for (int i = 0; i < this.evs.size(); ++i) {
            s2.append(this.evs.get(i));
            if (i + 1 >= this.evs.size()) continue;
            s2.append(",");
        }
        s2.append("}]");
        return s2.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toShortString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("@").append(this.getTypeName()).append("(");
        for (int i = 0; i < this.evs.size(); ++i) {
            s2.append(this.evs.get(i));
            if (i + 1 >= this.evs.size()) continue;
            s2.append(",");
        }
        s2.append(")");
        return s2.toString();
    }

    private void isRuntimeVisible(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean b) {
        this.isRuntimeVisible = b;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getAnnotationAttributes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntryGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] annotationEntryGens) {
        if (annotationEntryGens.length == 0) {
            return new Attribute[0];
        }
        try {
            int countVisible = 0;
            int countInvisible = 0;
            for (AnnotationEntryGen a : annotationEntryGens) {
                if (a.isRuntimeVisible()) {
                    ++countVisible;
                    continue;
                }
                ++countInvisible;
            }
            ByteArrayOutputStream rvaBytes = new ByteArrayOutputStream();
            ByteArrayOutputStream riaBytes = new ByteArrayOutputStream();
            DataOutputStream rvaDos = new DataOutputStream(rvaBytes);
            DataOutputStream riaDos = new DataOutputStream(riaBytes);
            rvaDos.writeShort(countVisible);
            riaDos.writeShort(countInvisible);
            for (AnnotationEntryGen a : annotationEntryGens) {
                if (a.isRuntimeVisible()) {
                    a.dump(rvaDos);
                    continue;
                }
                a.dump(riaDos);
            }
            rvaDos.close();
            riaDos.close();
            byte[] rvaData = rvaBytes.toByteArray();
            byte[] riaData = riaBytes.toByteArray();
            int rvaIndex = -1;
            int riaIndex = -1;
            if (rvaData.length > 2) {
                rvaIndex = cp.addUtf8("RuntimeVisibleAnnotations");
            }
            if (riaData.length > 2) {
                riaIndex = cp.addUtf8("RuntimeInvisibleAnnotations");
            }
            ArrayList<Annotations> newAttributes = new ArrayList<Annotations>();
            if (rvaData.length > 2) {
                newAttributes.add(new RuntimeVisibleAnnotations(rvaIndex, rvaData.length, new DataInputStream(new ByteArrayInputStream(rvaData)), cp.getConstantPool()));
            }
            if (riaData.length > 2) {
                newAttributes.add(new RuntimeInvisibleAnnotations(riaIndex, riaData.length, new DataInputStream(new ByteArrayInputStream(riaData)), cp.getConstantPool()));
            }
            return newAttributes.toArray(new Attribute[newAttributes.size()]);
        }
        catch (IOException e) {
            System.err.println("IOException whilst processing annotations");
            e.printStackTrace();
            return null;
        }
    }

    static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getParameterAnnotationAttributes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntryGen> @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] vec) {
        int[] visCount = new int[vec.length];
        int totalVisCount = 0;
        int[] invisCount = new int[vec.length];
        int totalInvisCount = 0;
        try {
            for (int i = 0; i < vec.length; ++i) {
                if (vec[i] == null) continue;
                for (AnnotationEntryGen element : vec[i]) {
                    if (element.isRuntimeVisible()) {
                        int n = i;
                        visCount[n] = visCount[n] + 1;
                        ++totalVisCount;
                        continue;
                    }
                    int n = i;
                    invisCount[n] = invisCount[n] + 1;
                    ++totalInvisCount;
                }
            }
            ByteArrayOutputStream rvaBytes = new ByteArrayOutputStream();
            DataOutputStream rvaDos = new DataOutputStream(rvaBytes);
            rvaDos.writeByte(vec.length);
            for (int i = 0; i < vec.length; ++i) {
                rvaDos.writeShort(visCount[i]);
                if (visCount[i] <= 0) continue;
                for (AnnotationEntryGen element : vec[i]) {
                    if (!element.isRuntimeVisible()) continue;
                    element.dump(rvaDos);
                }
            }
            rvaDos.close();
            ByteArrayOutputStream riaBytes = new ByteArrayOutputStream();
            DataOutputStream riaDos = new DataOutputStream(riaBytes);
            riaDos.writeByte(vec.length);
            for (int i = 0; i < vec.length; ++i) {
                riaDos.writeShort(invisCount[i]);
                if (invisCount[i] <= 0) continue;
                for (AnnotationEntryGen element : vec[i]) {
                    if (element.isRuntimeVisible()) continue;
                    element.dump(riaDos);
                }
            }
            riaDos.close();
            byte[] rvaData = rvaBytes.toByteArray();
            byte[] riaData = riaBytes.toByteArray();
            int rvaIndex = -1;
            int riaIndex = -1;
            if (totalVisCount > 0) {
                rvaIndex = cp.addUtf8("RuntimeVisibleParameterAnnotations");
            }
            if (totalInvisCount > 0) {
                riaIndex = cp.addUtf8("RuntimeInvisibleParameterAnnotations");
            }
            ArrayList<ParameterAnnotations> newAttributes = new ArrayList<ParameterAnnotations>();
            if (totalVisCount > 0) {
                newAttributes.add(new RuntimeVisibleParameterAnnotations(rvaIndex, rvaData.length, new DataInputStream(new ByteArrayInputStream(rvaData)), cp.getConstantPool()));
            }
            if (totalInvisCount > 0) {
                newAttributes.add(new RuntimeInvisibleParameterAnnotations(riaIndex, riaData.length, new DataInputStream(new ByteArrayInputStream(riaData)), cp.getConstantPool()));
            }
            return newAttributes.toArray(new Attribute[newAttributes.size()]);
        }
        catch (IOException e) {
            System.err.println("IOException whilst processing parameter annotations");
            e.printStackTrace();
            return null;
        }
    }
}

