/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMapType
implements Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte type;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index = -1;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool;

    StackMapType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(file.readByte(), -1, constant_pool);
        if (this.hasIndex()) {
            this.index = file.readShort();
        }
        this.constant_pool = constant_pool;
    }

    public StackMapType(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte type, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        if (type < 0 || type > 8) {
            throw new RuntimeException("Illegal type for StackMapType: " + type);
        }
        this.type = type;
        this.index = index;
        this.constant_pool = constant_pool;
    }

    public void setType(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte t) {
        if (t < 0 || t > 8) {
            throw new RuntimeException("Illegal type for StackMapType: " + t);
        }
        this.type = t;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte getType() {
        return this.type;
    }

    public void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int t) {
        this.index = t;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIndex() {
        return this.index;
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeByte(this.type);
        if (this.hasIndex()) {
            file.writeShort(this.getIndex());
        }
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean hasIndex() {
        return this.type == 7 || this.type == 8;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String printIndex() {
        if (this.type == 7) {
            if (this.index < 0) {
                return ", class=<unknown>";
            }
            return ", class=" + this.constant_pool.constantToString(this.index, (byte)7);
        }
        if (this.type == 8) {
            return ", offset=" + this.index;
        }
        return "";
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return "(type=" + Const.getItemName(this.type) + this.printIndex() + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StackMapType copy() {
        try {
            return (StackMapType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }
}

