/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Signature
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index;

    public Signature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Signature c) {
        this(c.getNameIndex(), c.getLength(), c.getSignatureIndex(), c.getConstantPool());
    }

    Signature(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(name_index, length, input.readUnsignedShort(), constant_pool);
    }

    public Signature(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super((byte)10, name_index, length, constant_pool);
        this.signature_index = signature_index;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitSignature(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.dump(file);
        file.writeShort(this.signature_index);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index) {
        this.signature_index = signature_index;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(this.signature_index, (byte)1);
        return c.getBytes();
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean identStart(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int ch) {
        return ch == 84 || ch == 76;
    }

    private static void matchIdent(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MyByteArrayInputStream in, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StringBuilder buf) {
        int ch = in.read();
        if (ch == -1) {
            throw new RuntimeException("Illegal signature: " + in.getData() + " no ident, reaching EOF");
        }
        if (!Signature.identStart(ch)) {
            StringBuilder buf2 = new StringBuilder();
            int count = 1;
            while (Character.isJavaIdentifierPart((char)ch)) {
                buf2.append((char)ch);
                ++count;
                ch = in.read();
            }
            if (ch == 58) {
                in.skip("Ljava/lang/Object".length());
                buf.append((CharSequence)buf2);
                ch = in.read();
                in.unread();
            } else {
                for (int i = 0; i < count; ++i) {
                    in.unread();
                }
            }
            return;
        }
        StringBuilder buf2 = new StringBuilder();
        ch = in.read();
        do {
            buf2.append((char)ch);
        } while ((ch = in.read()) != -1 && (Character.isJavaIdentifierPart((char)ch) || ch == 47));
        buf.append(buf2.toString().replace('/', '.'));
        if (ch != -1) {
            in.unread();
        }
    }

    private static void matchGJIdent(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MyByteArrayInputStream in, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StringBuilder buf) {
        Signature.matchIdent(in, buf);
        int ch = in.read();
        if (ch == 60 || ch == 40) {
            buf.append((char)ch);
            Signature.matchGJIdent(in, buf);
            while ((ch = in.read()) != 62 && ch != 41) {
                if (ch == -1) {
                    throw new RuntimeException("Illegal signature: " + in.getData() + " reaching EOF");
                }
                buf.append(", ");
                in.unread();
                Signature.matchGJIdent(in, buf);
            }
            buf.append((char)ch);
        } else {
            in.unread();
        }
        ch = in.read();
        if (Signature.identStart(ch)) {
            in.unread();
            Signature.matchGJIdent(in, buf);
        } else {
            if (ch == 41) {
                in.unread();
                return;
            }
            if (ch != 59) {
                throw new RuntimeException("Illegal signature: " + in.getData() + " read " + (char)ch);
            }
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String translate(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String s2) {
        StringBuilder buf = new StringBuilder();
        Signature.matchGJIdent(new MyByteArrayInputStream(s2), buf);
        return buf.toString();
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isFormalParameterList(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String s2) {
        return s2.startsWith("<") && s2.indexOf(58) > 0;
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isActualParameterList(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String s2) {
        return s2.startsWith("L") && s2.endsWith(">;");
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        String s2 = this.getSignature();
        return "Signature: " + s2;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        return (Attribute)this.clone();
    }

    private static final class MyByteArrayInputStream
    extends ByteArrayInputStream {
        MyByteArrayInputStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String data) {
            super(data.getBytes());
        }

        final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getData() {
            return new String(this.buf);
        }

        final void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }
    }
}

