/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.LocalVariable;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTypeTable
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] local_variable_type_table;

    public LocalVariableTypeTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariableTypeTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTypeTable(), c.getConstantPool());
    }

    public LocalVariableTypeTable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] local_variable_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super((byte)17, name_index, length, constant_pool);
        this.local_variable_type_table = local_variable_table;
    }

    LocalVariableTypeTable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int nameIdx, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int len, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cpool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(nameIdx, len, (LocalVariable[])null, cpool);
        int local_variable_type_table_length = input.readUnsignedShort();
        this.local_variable_type_table = new LocalVariable[local_variable_type_table_length];
        for (int i = 0; i < local_variable_type_table_length; ++i) {
            this.local_variable_type_table[i] = new LocalVariable(input, cpool);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitLocalVariableTypeTable(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.dump(file);
        file.writeShort(this.local_variable_type_table.length);
        for (LocalVariable variable : this.local_variable_type_table) {
            variable.dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getLocalVariableTypeTable() {
        return this.local_variable_type_table;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable getLocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        for (LocalVariable variable : this.local_variable_type_table) {
            if (variable.getIndex() != index) continue;
            return variable;
        }
        return null;
    }

    public final void setLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] local_variable_table) {
        this.local_variable_type_table = local_variable_table;
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.local_variable_type_table.length; ++i) {
            buf.append(this.local_variable_type_table[i].toStringShared(true));
            if (i >= this.local_variable_type_table.length - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        LocalVariableTypeTable c = (LocalVariableTypeTable)this.clone();
        c.local_variable_type_table = new LocalVariable[this.local_variable_type_table.length];
        for (int i = 0; i < this.local_variable_type_table.length; ++i) {
            c.local_variable_type_table[i] = this.local_variable_type_table[i].copy();
        }
        c.setConstantPool(constant_pool);
        return c;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTableLength() {
        return this.local_variable_type_table == null ? 0 : this.local_variable_type_table.length;
    }
}

