/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LocalVariable
implements Cloneable,
Node {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int start_pc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool;

    public LocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable c) {
        this(c.getStartPC(), c.getLength(), c.getNameIndex(), c.getSignatureIndex(), c.getIndex(), c.getConstantPool());
    }

    LocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), constant_pool);
    }

    public LocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int start_pc, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        this.start_pc = start_pc;
        this.length = length;
        this.name_index = name_index;
        this.signature_index = signature_index;
        this.index = index;
        this.constant_pool = constant_pool;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitLocalVariable(this);
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeShort(this.start_pc);
        file.writeShort(this.length);
        file.writeShort(this.name_index);
        file.writeShort(this.signature_index);
        file.writeShort(this.index);
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getLength() {
        return this.length;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getName() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return c.getBytes();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNameIndex() {
        return this.name_index;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return c.getBytes();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getSignatureIndex() {
        return this.signature_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIndex() {
        return this.index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getStartPC() {
        return this.start_pc;
    }

    final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toStringShared(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean typeTable) {
        String name = this.getName();
        String signature = Utility.signatureToString(this.getSignature(), false);
        String label = "LocalVariable" + (typeTable ? "Types" : "");
        return label + "(start_pc = " + this.start_pc + ", length = " + this.length + ", index = " + this.index + ":" + signature + " " + name + ")";
    }

    public final void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public final void setLength(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length) {
        this.length = length;
    }

    public final void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index) {
        this.name_index = name_index;
    }

    public final void setSignatureIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index) {
        this.signature_index = signature_index;
    }

    public final void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        this.index = index;
    }

    public final void setStartPC(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int start_pc) {
        this.start_pc = start_pc;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return this.toStringShared(false);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable copy() {
        try {
            return (LocalVariable)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

