/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.LineNumber;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumberTable
extends Attribute {
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int MAX_LINE_LENGTH = 72;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumber @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] line_number_table;

    public LineNumberTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumberTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLineNumberTable(), c.getConstantPool());
    }

    public LineNumberTable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumber @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] line_number_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super((byte)4, name_index, length, constant_pool);
        this.line_number_table = line_number_table;
    }

    LineNumberTable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(name_index, length, (LineNumber[])null, constant_pool);
        int line_number_table_length = input.readUnsignedShort();
        this.line_number_table = new LineNumber[line_number_table_length];
        for (int i = 0; i < line_number_table_length; ++i) {
            this.line_number_table[i] = new LineNumber(input);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitLineNumberTable(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.dump(file);
        file.writeShort(this.line_number_table.length);
        for (LineNumber lineNumber : this.line_number_table) {
            lineNumber.dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumber @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getLineNumberTable() {
        return this.line_number_table;
    }

    public final void setLineNumberTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumber @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] line_number_table) {
        this.line_number_table = line_number_table;
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder buf = new StringBuilder();
        StringBuilder line = new StringBuilder();
        String newLine = System.getProperty("line.separator", "\n");
        for (int i = 0; i < this.line_number_table.length; ++i) {
            line.append(this.line_number_table[i].toString());
            if (i < this.line_number_table.length - 1) {
                line.append(", ");
            }
            if (line.length() <= 72 || i >= this.line_number_table.length - 1) continue;
            line.append(newLine);
            buf.append((CharSequence)line);
            line.setLength(0);
        }
        buf.append((CharSequence)line);
        return buf.toString();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getSourceLine(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int pos) {
        int l = 0;
        int r = this.line_number_table.length - 1;
        if (r < 0) {
            return -1;
        }
        int min_index = -1;
        int min2 = -1;
        do {
            int i;
            int j;
            if ((j = this.line_number_table[i = (l + r) / 2].getStartPC()) == pos) {
                return this.line_number_table[i].getLineNumber();
            }
            if (pos < j) {
                r = i - 1;
            } else {
                l = i + 1;
            }
            if (j >= pos || j <= min2) continue;
            min2 = j;
            min_index = i;
        } while (l <= r);
        if (min_index < 0) {
            return -1;
        }
        return this.line_number_table[min_index].getLineNumber();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        LineNumberTable c = (LineNumberTable)this.clone();
        c.line_number_table = new LineNumber[this.line_number_table.length];
        for (int i = 0; i < this.line_number_table.length; ++i) {
            c.line_number_table[i] = this.line_number_table[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTableLength() {
        return this.line_number_table == null ? 0 : this.line_number_table.length;
    }
}

