/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ExceptionTable
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] exception_index_table;

    public ExceptionTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ExceptionTable c) {
        this(c.getNameIndex(), c.getLength(), c.getExceptionIndexTable(), c.getConstantPool());
    }

    public ExceptionTable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] exception_index_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super((byte)3, name_index, length, constant_pool);
        this.exception_index_table = exception_index_table != null ? exception_index_table : new int[]{};
    }

    ExceptionTable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(name_index, length, (int[])null, constant_pool);
        int number_of_exceptions = input.readUnsignedShort();
        this.exception_index_table = new int[number_of_exceptions];
        for (int i = 0; i < number_of_exceptions; ++i) {
            this.exception_index_table[i] = input.readUnsignedShort();
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitExceptionTable(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.dump(file);
        file.writeShort(this.exception_index_table.length);
        for (int index : this.exception_index_table) {
            file.writeShort(index);
        }
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getExceptionIndexTable() {
        return this.exception_index_table;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNumberOfExceptions() {
        return this.exception_index_table == null ? 0 : this.exception_index_table.length;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getExceptionNames() {
        String[] names = new String[this.exception_index_table.length];
        for (int i = 0; i < this.exception_index_table.length; ++i) {
            names[i] = super.getConstantPool().getConstantString(this.exception_index_table[i], (byte)7).replace('/', '.');
        }
        return names;
    }

    public final void setExceptionIndexTable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] exception_index_table) {
        this.exception_index_table = exception_index_table != null ? exception_index_table : new int[]{};
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Exceptions: ");
        for (int i = 0; i < this.exception_index_table.length; ++i) {
            String str = super.getConstantPool().getConstantString(this.exception_index_table[i], (byte)7);
            buf.append(Utility.compactClassName(str, false));
            if (i >= this.exception_index_table.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        ExceptionTable c = (ExceptionTable)this.clone();
        if (this.exception_index_table != null) {
            c.exception_index_table = new int[this.exception_index_table.length];
            System.arraycopy(this.exception_index_table, 0, c.exception_index_table, 0, this.exception_index_table.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

