/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantClass;
import afu.org.apache.commons.bcel6.classfile.ConstantNameAndType;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnclosingMethod
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int classIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int methodIndex;

    EnclosingMethod(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int len, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cpool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(nameIndex, len, input.readUnsignedShort(), input.readUnsignedShort(), cpool);
    }

    private EnclosingMethod(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int len, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int classIdx, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int methodIdx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cpool) {
        super((byte)18, nameIndex, len, cpool);
        this.classIndex = classIdx;
        this.methodIndex = methodIdx;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitEnclosingMethod(this);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        return (Attribute)this.clone();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getEnclosingClassIndex() {
        return this.classIndex;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getEnclosingMethodIndex() {
        return this.methodIndex;
    }

    public final void setEnclosingClassIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int idx) {
        this.classIndex = idx;
    }

    public final void setEnclosingMethodIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int idx) {
        this.methodIndex = idx;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantClass getEnclosingClass() {
        ConstantClass c = (ConstantClass)super.getConstantPool().getConstant(this.classIndex, (byte)7);
        return c;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantNameAndType getEnclosingMethod() {
        if (this.methodIndex == 0) {
            return null;
        }
        ConstantNameAndType nat = (ConstantNameAndType)super.getConstantPool().getConstant(this.methodIndex, (byte)12);
        return nat;
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.dump(file);
        file.writeShort(this.classIndex);
        file.writeShort(this.methodIndex);
    }
}

