/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ElementValue;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public class ElementValuePair {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue elementValue;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constantPool;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int elementNameIndex;

    public ElementValuePair(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int elementNameIndex, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue elementValue, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constantPool) {
        this.elementValue = elementValue;
        this.elementNameIndex = elementNameIndex;
        this.constantPool = constantPool;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getNameString() {
        ConstantUtf8 c = (ConstantUtf8)this.constantPool.getConstant(this.elementNameIndex, (byte)1);
        return c.getBytes();
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue getValue() {
        return this.elementValue;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNameIndex() {
        return this.elementNameIndex;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toShortString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getNameString()).append("=").append(this.getValue().toShortString());
        return result.toString();
    }

    protected void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        dos.writeShort(this.elementNameIndex);
        this.elementValue.dump(dos);
    }
}

