/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Constant;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

public final class ConstantUtf8
extends Constant {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String bytes;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int considered = 0;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hits = 0;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int skipped = 0;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int created = 0;
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int MAX_CACHED_SIZE = Integer.getInteger("bcel.maxcached.size", 200);
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean BCEL_STATISTICS = Boolean.getBoolean("bcel.statistics");

    static void printStats() {
        System.err.println("Cache hit " + hits + "/" + considered + ", " + skipped + " skipped");
        System.err.println("Total of " + created + " ConstantUtf8 objects created");
    }

    static void clearStats() {
        created = 0;
        skipped = 0;
        considered = 0;
        hits = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantUtf8 getCachedInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String s2) {
        if (s2.length() > MAX_CACHED_SIZE) {
            ++skipped;
            return new ConstantUtf8(s2);
        }
        ++considered;
        Class<ConstantUtf8> clazz = ConstantUtf8.class;
        synchronized (ConstantUtf8.class) {
            ConstantUtf8 result = (ConstantUtf8)CACHE_HOLDER.CACHE.get(s2);
            if (result != null) {
                ++hits;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
            result = new ConstantUtf8(s2);
            CACHE_HOLDER.CACHE.put(s2, result);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantUtf8 getInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String s2) {
        return new ConstantUtf8(s2);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantUtf8 getInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        return ConstantUtf8.getInstance(input.readUTF());
    }

    public ConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantUtf8 c) {
        this(c.getBytes());
    }

    ConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super((byte)1);
        this.bytes = file.readUTF();
        ++created;
    }

    public ConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String bytes) {
        super((byte)1);
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must not be null!");
        }
        this.bytes = bytes;
        ++created;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitConstantUtf8(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeByte(super.getTag());
        file.writeUTF(this.bytes);
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getBytes() {
        return this.bytes;
    }

    @Deprecated
    public final void setBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return super.toString() + "(\"" + Utility.replace(this.bytes, "\n", "\\n") + "\")";
    }

    static {
        if (BCEL_STATISTICS) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ConstantUtf8.printStats();
                }
            });
        }
    }

    private static class CACHE_HOLDER {
        private static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int MAX_CACHE_ENTRIES = 20000;
        private static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int INITIAL_CACHE_CAPACITY = 26666;
        private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString HashMap<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantUtf8> CACHE = new LinkedHashMap<String, ConstantUtf8>(26666, 0.75f, true){
            private static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString long serialVersionUID = -8506975356158971766L;

            @Override
            protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean removeEldestEntry( @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map.Entry<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantUtf8> eldest) {
                return this.size() > 20000;
            }
        };

        private CACHE_HOLDER() {
        }
    }
}

