/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Constant;
import afu.org.apache.commons.bcel6.classfile.ConstantObject;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantString
extends Constant
implements ConstantObject {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int string_index;

    public ConstantString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantString c) {
        this(c.getStringIndex());
    }

    ConstantString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(file.readUnsignedShort());
    }

    public ConstantString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int string_index) {
        super((byte)8);
        this.string_index = string_index;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitConstantString(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.string_index);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getStringIndex() {
        return this.string_index;
    }

    public final void setStringIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int string_index) {
        this.string_index = string_index;
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return super.toString() + "(string_index = " + this.string_index + ")";
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object getConstantValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp) {
        Constant c = cp.getConstant(this.string_index, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp) {
        return (String)this.getConstantValue(cp);
    }
}

