/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.classfile.ClassFormatException;
import afu.org.apache.commons.bcel6.classfile.Constant;
import afu.org.apache.commons.bcel6.classfile.ConstantCP;
import afu.org.apache.commons.bcel6.classfile.ConstantClass;
import afu.org.apache.commons.bcel6.classfile.ConstantDouble;
import afu.org.apache.commons.bcel6.classfile.ConstantFloat;
import afu.org.apache.commons.bcel6.classfile.ConstantInteger;
import afu.org.apache.commons.bcel6.classfile.ConstantInvokeDynamic;
import afu.org.apache.commons.bcel6.classfile.ConstantLong;
import afu.org.apache.commons.bcel6.classfile.ConstantMethodHandle;
import afu.org.apache.commons.bcel6.classfile.ConstantMethodType;
import afu.org.apache.commons.bcel6.classfile.ConstantNameAndType;
import afu.org.apache.commons.bcel6.classfile.ConstantString;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import afu.org.checkerframework.framework.qual.AnnotatedFor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

@AnnotatedFor(value={"nullness"})
public class ConstantPool
implements Cloneable,
Node {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Constant @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] constant_pool;

    public ConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Constant @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] constant_pool) {
        this.constant_pool = constant_pool;
    }

    public ConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        int constant_pool_count = input.readUnsignedShort();
        this.constant_pool = new Constant[constant_pool_count];
        for (int i = 1; i < constant_pool_count; ++i) {
            this.constant_pool[i] = Constant.readConstant(input);
            byte tag = this.constant_pool[i].getTag();
            if (tag != 6 && tag != 5) continue;
            ++i;
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitConstantPool(this);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String constantToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Constant c) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        String str;
        byte tag = c.getTag();
        switch (tag) {
            case 7: {
                int i = ((ConstantClass)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = this.getConstant(i, (byte)1);
                str = "\"" + ConstantPool.escape(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            case 1: {
                str = ((ConstantUtf8)c).getBytes();
                break;
            }
            case 6: {
                str = String.valueOf(((ConstantDouble)c).getBytes());
                break;
            }
            case 4: {
                str = String.valueOf(((ConstantFloat)c).getBytes());
                break;
            }
            case 5: {
                str = String.valueOf(((ConstantLong)c).getBytes());
                break;
            }
            case 3: {
                str = String.valueOf(((ConstantInteger)c).getBytes());
                break;
            }
            case 12: {
                str = this.constantToString(((ConstantNameAndType)c).getNameIndex(), (byte)1) + ":" + this.constantToString(((ConstantNameAndType)c).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                str = this.constantToString(((ConstantCP)c).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)c).getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 15: {
                ConstantMethodHandle cmh = (ConstantMethodHandle)c;
                str = Const.getMethodHandleName(cmh.getReferenceKind()) + " " + this.constantToString(cmh.getReferenceIndex(), this.getConstant(cmh.getReferenceIndex()).getTag());
                break;
            }
            case 16: {
                ConstantMethodType cmt = (ConstantMethodType)c;
                str = this.constantToString(cmt.getDescriptorIndex(), (byte)1);
                break;
            }
            case 18: {
                ConstantInvokeDynamic cid = (ConstantInvokeDynamic)c;
                str = cid.getBootstrapMethodAttrIndex() + ":" + this.constantToString(cid.getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + tag);
            }
        }
        return str;
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String escape(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String str) {
        int len = str.length();
        StringBuilder buf = new StringBuilder(len + 5);
        char[] ch = str.toCharArray();
        block7: for (int i = 0; i < len; ++i) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
        }
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String constantToString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte tag) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        Constant c = this.getConstant(index, tag);
        return this.constantToString(c);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeShort(this.constant_pool.length);
        for (int i = 1; i < this.constant_pool.length; ++i) {
            if (this.constant_pool[i] == null) continue;
            this.constant_pool[i].dump(file);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Constant getConstant(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        if (index >= this.constant_pool.length || index < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[index];
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Constant getConstant(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte tag) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        Constant c = this.getConstant(index);
        if (c == null) {
            throw new ClassFormatException("Constant pool at index " + index + " is null.");
        }
        if (c.getTag() != tag) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(tag) + "' at index " + index + " and got " + c);
        }
        return c;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Constant @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getConstantPool() {
        return this.constant_pool;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getConstantString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte tag) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        int i;
        Constant c = this.getConstant(index, tag);
        switch (tag) {
            case 7: {
                i = ((ConstantClass)c).getNameIndex();
                break;
            }
            case 8: {
                i = ((ConstantString)c).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + tag);
            }
        }
        c = this.getConstant(i, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getLength() {
        return this.constant_pool == null ? 0 : this.constant_pool.length;
    }

    public void setConstant(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Constant constant) {
        this.constant_pool[index] = constant;
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Constant @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] constant_pool) {
        this.constant_pool = constant_pool;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < this.constant_pool.length; ++i) {
            buf.append(i).append(")").append(this.constant_pool[i]).append("\n");
        }
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool copy() {
        ConstantPool c = null;
        try {
            c = (ConstantPool)this.clone();
            c.constant_pool = new Constant[this.constant_pool.length];
            for (int i = 1; i < this.constant_pool.length; ++i) {
                if (this.constant_pool[i] == null) continue;
                c.constant_pool[i] = this.constant_pool[i].copy();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }
}

