/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class CodeException
implements Cloneable,
Node {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int start_pc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int end_pc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int handler_pc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int catch_type;

    public CodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CodeException c) {
        this(c.getStartPC(), c.getEndPC(), c.getHandlerPC(), c.getCatchType());
    }

    CodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort());
    }

    public CodeException(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int start_pc, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int end_pc, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int handler_pc, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int catch_type) {
        this.start_pc = start_pc;
        this.end_pc = end_pc;
        this.handler_pc = handler_pc;
        this.catch_type = catch_type;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitCodeException(this);
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeShort(this.start_pc);
        file.writeShort(this.end_pc);
        file.writeShort(this.handler_pc);
        file.writeShort(this.catch_type);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getCatchType() {
        return this.catch_type;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getEndPC() {
        return this.end_pc;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getHandlerPC() {
        return this.handler_pc;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getStartPC() {
        return this.start_pc;
    }

    public final void setCatchType(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int catch_type) {
        this.catch_type = catch_type;
    }

    public final void setEndPC(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int end_pc) {
        this.end_pc = end_pc;
    }

    public final void setHandlerPC(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int handler_pc) {
        this.handler_pc = handler_pc;
    }

    public final void setStartPC(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int start_pc) {
        this.start_pc = start_pc;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return "CodeException(start_pc = " + this.start_pc + ", end_pc = " + this.end_pc + ", handler_pc = " + this.handler_pc + ", catch_type = " + this.catch_type + ")";
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        String str = this.catch_type == 0 ? "<Any exception>(0)" : Utility.compactClassName(cp.getConstantString(this.catch_type, (byte)7), false) + (verbose ? "(" + this.catch_type + ")" : "");
        return this.start_pc + "\t" + this.end_pc + "\t" + this.handler_pc + "\t" + str;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp) {
        return this.toString(cp, true);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CodeException copy() {
        try {
            return (CodeException)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

