/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.BootstrapMethod;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class BootstrapMethods
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] bootstrap_methods;

    public BootstrapMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BootstrapMethods c) {
        this(c.getNameIndex(), c.getLength(), c.getBootstrapMethods(), c.getConstantPool());
    }

    public BootstrapMethods(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] bootstrap_methods, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super((byte)20, name_index, length, constant_pool);
        this.bootstrap_methods = bootstrap_methods;
    }

    BootstrapMethods(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(name_index, length, (BootstrapMethod[])null, constant_pool);
        int num_bootstrap_methods = input.readUnsignedShort();
        this.bootstrap_methods = new BootstrapMethod[num_bootstrap_methods];
        for (int i = 0; i < num_bootstrap_methods; ++i) {
            this.bootstrap_methods[i] = new BootstrapMethod(input);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getBootstrapMethods() {
        return this.bootstrap_methods;
    }

    public final void setBootstrapMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] bootstrap_methods) {
        this.bootstrap_methods = bootstrap_methods;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitBootstrapMethods(this);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BootstrapMethods copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        BootstrapMethods c = (BootstrapMethods)this.clone();
        c.bootstrap_methods = new BootstrapMethod[this.bootstrap_methods.length];
        for (int i = 0; i < this.bootstrap_methods.length; ++i) {
            c.bootstrap_methods[i] = this.bootstrap_methods[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.dump(file);
        file.writeShort(this.bootstrap_methods.length);
        for (BootstrapMethod bootstrap_method : this.bootstrap_methods) {
            bootstrap_method.dump(file);
        }
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("BootstrapMethods(");
        buf.append(this.bootstrap_methods.length);
        buf.append("):\n");
        for (int i = 0; i < this.bootstrap_methods.length; ++i) {
            buf.append("  ").append(i).append(": ");
            buf.append(this.bootstrap_methods[i].toString(super.getConstantPool())).append("\n");
        }
        return buf.toString();
    }
}

