/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class BootstrapMethod
implements Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int bootstrap_method_ref;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] bootstrap_arguments;

    public BootstrapMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BootstrapMethod c) {
        this(c.getBootstrapMethodRef(), c.getBootstrapArguments());
    }

    BootstrapMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(input.readUnsignedShort(), input.readUnsignedShort());
        for (int i = 0; i < this.bootstrap_arguments.length; ++i) {
            this.bootstrap_arguments[i] = input.readUnsignedShort();
        }
    }

    private BootstrapMethod(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int bootstrap_method_ref, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int num_bootstrap_arguments) {
        this(bootstrap_method_ref, new int[num_bootstrap_arguments]);
    }

    public BootstrapMethod(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int bootstrap_method_ref, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] bootstrap_arguments) {
        this.bootstrap_method_ref = bootstrap_method_ref;
        this.bootstrap_arguments = bootstrap_arguments;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getBootstrapMethodRef() {
        return this.bootstrap_method_ref;
    }

    public void setBootstrapMethodRef(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int bootstrap_method_ref) {
        this.bootstrap_method_ref = bootstrap_method_ref;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getBootstrapArguments() {
        return this.bootstrap_arguments;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNumBootstrapArguments() {
        return this.bootstrap_arguments.length;
    }

    public void setBootstrapArguments(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] bootstrap_arguments) {
        this.bootstrap_arguments = bootstrap_arguments;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return "BootstrapMethod(" + this.bootstrap_method_ref + ", " + this.bootstrap_arguments.length + ", " + Arrays.toString(this.bootstrap_arguments) + ")";
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String bootstrap_method_name = constant_pool.constantToString(this.bootstrap_method_ref, (byte)15);
        buf.append(Utility.compactClassName(bootstrap_method_name));
        int num_bootstrap_arguments = this.bootstrap_arguments.length;
        if (num_bootstrap_arguments > 0) {
            buf.append("\n     Method Arguments:");
            for (int i = 0; i < num_bootstrap_arguments; ++i) {
                buf.append("\n     ").append(i).append(": ");
                buf.append(constant_pool.constantToString(constant_pool.getConstant(this.bootstrap_arguments[i])));
            }
        }
        return buf.toString();
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeShort(this.bootstrap_method_ref);
        file.writeShort(this.bootstrap_arguments.length);
        for (int bootstrap_argument : this.bootstrap_arguments) {
            file.writeShort(bootstrap_argument);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BootstrapMethod copy() {
        try {
            return (BootstrapMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

