/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.AnnotationEntry;
import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Annotations
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] annotation_table;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isRuntimeVisible;

    Annotations(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte annotation_type, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isRuntimeVisible) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(annotation_type, name_index, length, (AnnotationEntry[])null, constant_pool, isRuntimeVisible);
        int annotation_table_length = input.readUnsignedShort();
        this.annotation_table = new AnnotationEntry[annotation_table_length];
        for (int i = 0; i < annotation_table_length; ++i) {
            this.annotation_table[i] = AnnotationEntry.read(input, constant_pool, isRuntimeVisible);
        }
    }

    public Annotations(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte annotation_type, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] annotation_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isRuntimeVisible) {
        super(annotation_type, name_index, length, constant_pool);
        this.annotation_table = annotation_table;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitAnnotation(this);
    }

    public final void setAnnotationTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] annotation_table) {
        this.annotation_table = annotation_table;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getAnnotationEntries() {
        return this.annotation_table;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNumAnnotations() {
        if (this.annotation_table == null) {
            return 0;
        }
        return this.annotation_table.length;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    protected void writeAnnotations(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        if (this.annotation_table == null) {
            return;
        }
        dos.writeShort(this.annotation_table.length);
        for (AnnotationEntry element : this.annotation_table) {
            element.dump(dos);
        }
    }
}

