/*
 * Decompiled with CFR 0.152.
 */
package afu.nu.xom.xslt;

import afu.nu.xom.converters.SAXConverter;
import afu.nu.xom.xslt.XOMInputSource;
import afu.nu.xom.xslt.XSLTHandler;
import afu.org.xml.sax.ContentHandler;
import afu.org.xml.sax.DTDHandler;
import afu.org.xml.sax.EntityResolver;
import afu.org.xml.sax.ErrorHandler;
import afu.org.xml.sax.InputSource;
import afu.org.xml.sax.SAXException;
import afu.org.xml.sax.SAXNotRecognizedException;
import afu.org.xml.sax.SAXNotSupportedException;
import afu.org.xml.sax.XMLReader;
import afu.org.xml.sax.ext.LexicalHandler;
import java.io.IOException;

class XOMReader
implements XMLReader {
    private SAXConverter converter;

    XOMReader() {
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string) || "http://xml.org/sax/features/namespaces".equals(string)) {
            return true;
        }
        throw new SAXNotRecognizedException("XOMReader doesn't support features");
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            return this.converter.getLexicalHandler();
        }
        throw new SAXNotRecognizedException("XOMReader doesn't support features");
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!"http://xml.org/sax/properties/lexical-handler".equals(string)) {
            throw new SAXNotRecognizedException("XOMReader doesn't support " + string);
        }
        LexicalHandler lexicalHandler = (LexicalHandler)object;
        this.converter.setLexicalHandler(lexicalHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        throw new UnsupportedOperationException();
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.converter = new SAXConverter(contentHandler);
        this.converter.setContentHandler(new XSLTHandler(null));
    }

    public ContentHandler getContentHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        XOMInputSource xOMInputSource = (XOMInputSource)inputSource;
        this.converter.convert(xOMInputSource.getNodes());
    }

    public void parse(String string) throws IOException, SAXException {
        throw new UnsupportedOperationException();
    }
}

