/*
 * Decompiled with CFR 0.152.
 */
package afu.nu.xom.jaxen.function;

import afu.nu.xom.jaxen.Context;
import afu.nu.xom.jaxen.Function;
import afu.nu.xom.jaxen.FunctionCallException;
import afu.nu.xom.jaxen.Navigator;
import afu.nu.xom.jaxen.function.StringFunction;
import java.util.List;

public class StringLengthFunction
implements Function {
    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() == 0) {
            return StringLengthFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (list.size() == 1) {
            return StringLengthFunction.evaluate(list.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string-length() requires one argument.");
    }

    public static Double evaluate(Object object, Navigator navigator) throws FunctionCallException {
        String string = StringFunction.evaluate(object, navigator);
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            ++n;
            if (c < '\ud800' || c > '\udfff') continue;
            try {
                char c2 = cArray[i + 1];
                if (c2 < '\udc00' || c2 > '\udfff') {
                    throw new FunctionCallException("Bad surrogate pair in string " + string);
                }
                ++i;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new FunctionCallException("Bad surrogate pair in string " + string);
            }
        }
        return new Double(n);
    }
}

