/*
 * Decompiled with CFR 0.152.
 */
package afu.nu.xom;

import afu.nu.xom.IllegalDataException;
import afu.nu.xom.IllegalNameException;
import afu.nu.xom.IllegalTargetException;
import afu.nu.xom.Node;
import afu.nu.xom.Text;
import afu.nu.xom.Verifier;

public class ProcessingInstruction
extends Node {
    private String target;
    private String data;

    public ProcessingInstruction(String string, String string2) {
        this._setTarget(string);
        this._setValue(string2);
    }

    public ProcessingInstruction(ProcessingInstruction processingInstruction) {
        this.target = processingInstruction.target;
        this.data = processingInstruction.data;
    }

    private ProcessingInstruction() {
    }

    static ProcessingInstruction build(String string, String string2) {
        ProcessingInstruction processingInstruction = new ProcessingInstruction();
        processingInstruction.target = string;
        processingInstruction.data = string2;
        return processingInstruction;
    }

    public final String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this._setTarget(string);
    }

    private void _setTarget(String string) {
        try {
            Verifier.checkNCName(string);
        }
        catch (IllegalNameException illegalNameException) {
            IllegalTargetException illegalTargetException = new IllegalTargetException(illegalNameException.getMessage());
            illegalTargetException.setData(string);
            throw illegalTargetException;
        }
        if (string.equalsIgnoreCase("xml")) {
            IllegalTargetException illegalTargetException = new IllegalTargetException(string + " is not a legal processing instruction target.");
            illegalTargetException.setData(string);
            throw illegalTargetException;
        }
        this.target = string;
    }

    public void setValue(String string) {
        this._setValue(string);
    }

    private void _setValue(String string) {
        Verifier.checkPCDATA(string);
        if (string.length() != 0) {
            if (string.indexOf("?>") >= 0) {
                IllegalDataException illegalDataException = new IllegalDataException("Processing instruction data must not contain \"?>\"");
                illegalDataException.setData(string);
                throw illegalDataException;
            }
            if (string.indexOf(13) >= 0) {
                IllegalDataException illegalDataException = new IllegalDataException("Processing instruction data cannot contain carriage returns");
                illegalDataException.setData(string);
                throw illegalDataException;
            }
            char c = string.charAt(0);
            if (c == ' ' || c == '\n' || c == '\t') {
                IllegalDataException illegalDataException = new IllegalDataException("Processing instruction data cannot contain leading white space");
                illegalDataException.setData(string);
                throw illegalDataException;
            }
        }
        this.data = string;
    }

    public final String getValue() {
        return this.data;
    }

    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("LeafNodes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public final String toXML() {
        StringBuffer stringBuffer = new StringBuffer("<?");
        stringBuffer.append(this.target);
        if (this.data.length() > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(this.data);
        }
        stringBuffer.append("?>");
        return stringBuffer.toString();
    }

    public Node copy() {
        return new ProcessingInstruction(this.target, this.data);
    }

    boolean isProcessingInstruction() {
        return true;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": target=\"" + this.target + "\"; data=\"" + Text.escapeLineBreaksAndTruncate(this.data) + "\"]";
    }
}

