/*
 * Decompiled with CFR 0.152.
 */
package afu.nu.xom;

import afu.nu.xom.IllegalDataException;
import afu.nu.xom.MalformedURIException;
import afu.nu.xom.Node;
import afu.nu.xom.Verifier;
import afu.nu.xom.WellformednessException;

public class DocType
extends Node {
    private String rootName;
    private String systemID;
    private String publicID;
    private String internalDTDSubset = "";

    public DocType(String string, String string2, String string3) {
        this._setRootElementName(string);
        this._setSystemID(string3);
        this._setPublicID(string2);
    }

    public DocType(String string, String string2) {
        this(string, null, string2);
    }

    public DocType(String string) {
        this(string, null, null);
    }

    public DocType(DocType docType) {
        this.internalDTDSubset = docType.internalDTDSubset;
        this.publicID = docType.publicID;
        this.systemID = docType.systemID;
        this.rootName = docType.rootName;
    }

    private DocType() {
    }

    static DocType build(String string, String string2, String string3) {
        DocType docType = new DocType();
        docType.publicID = string2;
        docType.systemID = string3;
        docType.rootName = string;
        return docType;
    }

    public final String getRootElementName() {
        return this.rootName;
    }

    public void setRootElementName(String string) {
        this._setRootElementName(string);
    }

    private void _setRootElementName(String string) {
        Verifier.checkXMLName(string);
        this.rootName = string;
    }

    public final String getInternalDTDSubset() {
        return this.internalDTDSubset;
    }

    public final void setInternalDTDSubset(String string) {
        if (string != null && string.length() > 0) {
            Verifier.checkInternalDTDSubset(string);
            this.fastSetInternalDTDSubset(string);
        } else {
            this.internalDTDSubset = "";
        }
    }

    final void fastSetInternalDTDSubset(String string) {
        this.internalDTDSubset = string;
    }

    public final String getPublicID() {
        return this.publicID;
    }

    public void setPublicID(String string) {
        this._setPublicID(string);
    }

    private void _setPublicID(String string) {
        int n;
        if (this.systemID == null && string != null) {
            throw new WellformednessException("Cannot have a public ID without a system ID");
        }
        if (string != null && (n = string.length()) != 0) {
            if (Verifier.isXMLSpaceCharacter(string.charAt(0))) {
                throw new IllegalDataException("Initial white space in public IDs is not round trippable.");
            }
            if (Verifier.isXMLSpaceCharacter(string.charAt(n - 1))) {
                throw new IllegalDataException("Trailing white space in public IDs is not round trippable.");
            }
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!DocType.isXMLPublicIDCharacter(c)) {
                    throw new IllegalDataException("The character 0x" + Integer.toHexString(c) + " is not allowed in public IDs");
                }
                if (c != ' ' || string.charAt(i - 1) != ' ') continue;
                throw new IllegalDataException("Multiple consecutive spaces in public IDs are not round trippable.");
            }
        }
        this.publicID = string;
    }

    public final String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String string) {
        this._setSystemID(string);
    }

    private void _setSystemID(String string) {
        if (string == null && this.publicID != null) {
            throw new WellformednessException("Cannot remove system ID without removing public ID first");
        }
        if (string != null) {
            Verifier.checkURIReference(string);
            if (string.indexOf(35) != -1) {
                MalformedURIException malformedURIException = new MalformedURIException("System literals cannot contain fragment identifiers");
                malformedURIException.setData(string);
                throw malformedURIException;
            }
        }
        this.systemID = string;
    }

    public final String getValue() {
        return "";
    }

    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("Document type declarations do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.rootName + "]";
    }

    public Node copy() {
        return new DocType(this);
    }

    public final String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE ");
        stringBuffer.append(this.rootName);
        if (this.publicID != null) {
            stringBuffer.append(" PUBLIC \"");
            stringBuffer.append(this.publicID);
            stringBuffer.append("\" \"");
            stringBuffer.append(this.systemID);
            stringBuffer.append('\"');
        } else if (this.systemID != null) {
            stringBuffer.append(" SYSTEM \"");
            stringBuffer.append(this.systemID);
            stringBuffer.append('\"');
        }
        if (this.internalDTDSubset.length() != 0) {
            stringBuffer.append(" [\n");
            stringBuffer.append(this.internalDTDSubset);
            stringBuffer.append(']');
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    boolean isDocType() {
        return true;
    }

    private static boolean isXMLPublicIDCharacter(char c) {
        switch (c) {
            case ' ': {
                return true;
            }
            case '!': {
                return true;
            }
            case '\"': {
                return false;
            }
            case '#': {
                return true;
            }
            case '$': {
                return true;
            }
            case '%': {
                return true;
            }
            case '&': {
                return false;
            }
            case '\'': {
                return true;
            }
            case '(': {
                return true;
            }
            case ')': {
                return true;
            }
            case '*': {
                return true;
            }
            case '+': {
                return true;
            }
            case ',': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return true;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return true;
            }
            case ';': {
                return true;
            }
            case '<': {
                return false;
            }
            case '=': {
                return true;
            }
            case '>': {
                return false;
            }
            case '?': {
                return true;
            }
            case '@': {
                return true;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return true;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
        }
        return false;
    }
}

