/*
 * Decompiled with CFR 0.152.
 */
package afu.net.fortuna.ical4j.util;

import afu.net.fortuna.ical4j.util.CompatibilityHints;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public final class Uris {
    public static final String INVALID_SCHEME = "afu.net.fortunal.ical4j.invalid";
    private static final Pattern CID_PATTERN = Pattern.compile("(?i)^cid:.*");
    private static final Pattern NOTES_CID_REPLACEMENT_PATTERN = Pattern.compile("[<>]");

    private Uris() {
    }

    public static String encode(String s2) {
        if (CompatibilityHints.isHintEnabled("ical4j.compatibility.notes") && CID_PATTERN.matcher(s2).matches()) {
            return NOTES_CID_REPLACEMENT_PATTERN.matcher(s2).replaceAll("");
        }
        return s2;
    }

    public static String decode(String s2) {
        return s2;
    }

    public static URI create(String s2) throws URISyntaxException {
        try {
            return new URI(Uris.encode(s2));
        }
        catch (URISyntaxException use) {
            if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed")) {
                String encoded = Uris.encode(s2);
                int index = encoded.indexOf(58);
                if (index != -1 && index < encoded.length() - 1) {
                    try {
                        return new URI(encoded.substring(0, index), encoded.substring(index + 1), null);
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                try {
                    return new URI(INVALID_SCHEME, s2, null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException("Could not build URI from " + s2);
                }
            }
            throw use;
        }
    }
}

