/*
 * Decompiled with CFR 0.152.
 */
package afu.net.fortuna.ical4j.util;

import afu.net.fortuna.ical4j.model.parameter.Encoding;
import afu.net.fortuna.ical4j.util.DecoderFactory;
import afu.org.apache.commons.codec.BinaryDecoder;
import afu.org.apache.commons.codec.StringDecoder;
import afu.org.apache.commons.codec.binary.Base64;
import afu.org.apache.commons.codec.net.QuotedPrintableCodec;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;

public class DefaultDecoderFactory
extends DecoderFactory {
    private static final String UNSUPPORTED_ENCODING_MESSAGE = "Decoder not available for encoding [{0}]";

    public BinaryDecoder createBinaryDecoder(Encoding encoding) throws UnsupportedEncodingException {
        if (Encoding.QUOTED_PRINTABLE.equals(encoding)) {
            return new QuotedPrintableCodec();
        }
        if (Encoding.BASE64.equals(encoding)) {
            return new Base64();
        }
        throw new UnsupportedEncodingException(MessageFormat.format(UNSUPPORTED_ENCODING_MESSAGE, encoding));
    }

    public StringDecoder createStringDecoder(Encoding encoding) throws UnsupportedEncodingException {
        if (Encoding.QUOTED_PRINTABLE.equals(encoding)) {
            return new QuotedPrintableCodec();
        }
        throw new UnsupportedEncodingException(MessageFormat.format(UNSUPPORTED_ENCODING_MESSAGE, encoding));
    }
}

